% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/glm_reg.R
\name{plot.glm_predict}
\alias{plot.glm_predict}
\title{Plot method for the predict.glm_reg function}
\usage{
\method{plot}{glm_predict}(x, glm_xvar = "", glm_facet_row = ".",
  glm_facet_col = ".", glm_color = "none", glm_conf_level = 0.95, ...)
}
\arguments{
\item{x}{Return value from \code{\link{predict.glm_reg}}.}

\item{glm_xvar}{Variable to display along the X-axis of the plot}

\item{glm_facet_row}{Create vertically arranged subplots for each level of the selected factor variable}

\item{glm_facet_col}{Create horizontally arranged subplots for each level of the selected factor variable}

\item{glm_color}{Adds color to a scatter plot to generate a heat map. For a line plot one line is created for each group and each is assigned a different colour}

\item{glm_conf_level}{Confidence level to use for prediction intervals (.95 is the default). Note that the error bars for predicitions are approximations at this point.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the predict.glm_reg function
}
\details{
See \url{http://mostly-harmless.github.io/radiant/quant/glm_reg} for an example in Radiant
}
\examples{
result <- glm_reg("titanic", "survived", c("pclass","sex","age"), glm_levels = "Yes")
pred <- predict(result, glm_predict_cmd = "pclass = levels(pclass)")
plot(pred, glm_xvar = "pclass")
pred <- predict(result, glm_predict_cmd = "age = 0:100")
plot(pred, glm_xvar = "age")
pred <- predict(result, glm_predict_cmd = "pclass = levels(pclass), sex = levels(sex)")
plot(pred, glm_xvar = "pclass", glm_color = "sex")
pred <- predict(result, glm_predict_cmd = "pclass = levels(pclass), age = seq(0,100,20)")
plot(pred, glm_xvar = "pclass", glm_color = "age")
plot(pred, glm_xvar = "age", glm_color = "pclass")
pred <- predict(result, glm_predict_cmd="pclass=levels(pclass), sex=levels(sex), age=seq(0,100,20)")
plot(pred, glm_xvar = "age", glm_color = "sex", glm_facet_col = "pclass")
plot(pred, glm_xvar = "age", glm_color = "pclass", glm_facet_col = "sex")
pred <- predict(result, glm_predict_cmd="pclass=levels(pclass), sex=levels(sex), age=seq(0,100,5)")
plot(pred, glm_xvar = "age", glm_color = "sex", glm_facet_col = "pclass")
plot(pred, glm_xvar = "age", glm_color = "pclass", glm_facet_col = "sex")
}
\seealso{
\code{\link{glm_reg}} to generate the result

\code{\link{summary.glm_reg}} to summarize results

\code{\link{plot.glm_reg}} to plot results

\code{\link{predict.glm_reg}} to generate predictions
}

