% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/kmeans_clus.R
\name{kmeans_clus}
\alias{kmeans_clus}
\title{K-means cluster analysis}
\usage{
kmeans_clus(dataset, km_vars, data_filter = "", km_hc_init = TRUE,
  km_dist = "sq.euclidian", km_meth = "ward.D", km_seed = 1234,
  km_nr_clus = 2)
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{km_vars}{Vector of variables to include in the analysis}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{km_hc_init}{Use centers from hier_clus as the starting point}

\item{km_dist}{Distance for hier_clus}

\item{km_meth}{Method for hier_clus}

\item{km_seed}{Random see to use for kmeans if km_hc_init is FALSE}

\item{km_nr_clus}{Number of clusters to extract}
}
\value{
A list of all variables used in kmeans_clus as an object of class kmeans_clus
}
\description{
K-means cluster analysis
}
\details{
See \url{http://vnijs.github.io/radiant/marketing/kmeans_clus.html} for an example in Radiant
}
\examples{
result <- kmeans_clus("shopping", c("v1:v6"))
}
\seealso{
\code{\link{summary.kmeans_clus}} to summarize results

\code{\link{plot.kmeans_clus}} to plot results

\code{\link{save_membership}} to add cluster membership to the selected dataset
}

