% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/regression.R
\name{predict.regression}
\alias{predict.regression}
\title{Predict method for the regression function}
\usage{
\method{predict}{regression}(object, reg_predict_cmd = "",
  reg_predict_data = "", reg_conf_level = 0.95, reg_save_pred = FALSE,
  ...)
}
\arguments{
\item{object}{Return value from \code{\link{regression}}}

\item{reg_predict_cmd}{Command used to generate data for prediction}

\item{reg_predict_data}{Name of the dataset to use for prediction}

\item{reg_conf_level}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{reg_save_pred}{Save predicted values to a csv file}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the regression function
}
\details{
See \url{http://vnijs.github.io/radiant/quant/regression.html} for an example in Radiant
}
\examples{
result <- regression("diamonds", "price", c("carat","clarity"))
predict(result, reg_predict_cmd = "carat = 1:10")
predict(result, reg_predict_cmd = "clarity = levels(clarity)")
result <- regression("diamonds", "price", c("carat","clarity"), reg_int_var = c("carat:clarity"))
dpred <- getdata("diamonds") \%>\% slice(1:10)
predict(result, reg_predict_data = "dpred")
}
\seealso{
\code{\link{regression}} to generate the result

\code{\link{summary.regression}} to summarize results

\code{\link{plot.regression}} to plot results
}

