% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_save_spectrum.R
\name{RN_save_spectrum}
\alias{RN_save_spectrum}
\title{Save radionuclide emission spectra.}
\usage{
RN_save_spectrum(desired_RN, rad_type = NULL, photon = FALSE, prob_cut = 0)
}
\arguments{
\item{desired_RN}{Radionuclide in form "Ba-137m"}

\item{rad_type}{Radiation type, leave NULL if selecting photons or
select from:
'X' for X-Ray
'G' for Gamma
'AE' for Auger Electron
'IE' for Internal Conversion Electron
'A' for Alpha
'AR' for Alpha Recoil
'B-' for Beta Negative
'AQ' for Annihilation Quanta
'B+' for Beta Positive
'PG' for Prompt Gamma
'DG' for Delayed Gamma
'DB' for Delayed Beta
'FF' for Fission Fragment
'N' for Neutron}

\item{photon}{'Y' to select all rad_types that are photons}

\item{prob_cut}{minimum probability defaults to 0}
}
\value{
Dataframe with energy spectra - including probability of emission quantum, or, for 
beta, the probability density.
}
\description{
Save emission spectra based on radionuclide and desired radiation type.
Select cutoff value for probability optional, included at 1% by default.
}
\examples{
Sr_Y_90_df <- RN_save_spectrum(desired_RN = c("Sr-90", "Y-90"), rad_type = "B-", 
photon = FALSE, prob_cut = 0.01)
Co_60_Ba_137m_p_df <- RN_save_spectrum(desired_RN = c("Co-60", "Ba-137m"), rad_type = NULL, 
photon = TRUE, prob_cut = 0.015)
Co_60_Ba_137m_g_df <- RN_save_spectrum(desired_RN = c("Co-60", "Ba-137m"), rad_type = "G")
actinide_a_df <- RN_save_spectrum(desired_RN = c("Pu-238", "Pu-239", "Am-241"), rad_type = "A",
photon = FALSE, prob_cut = 0.01)
}
\seealso{
Other radionuclides: 
\code{\link{RN_Spec_Act}()},
\code{\link{RN_bin_screen_phot}()},
\code{\link{RN_index_screen}()},
\code{\link{RN_info}()},
\code{\link{RN_plot_search_results}()},
\code{\link{RN_plot_spectrum}()},
\code{\link{RN_search_alpha_by_E}()},
\code{\link{RN_search_beta_by_E}()},
\code{\link{RN_search_phot_by_E}()}
}
\concept{radionuclides}
