% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{ragnar_store_create}
\alias{ragnar_store_create}
\title{Create and connect to a vector store}
\usage{
ragnar_store_create(
  location = ":memory:",
  embed = embed_ollama(),
  embedding_size = ncol(embed("foo")),
  overwrite = FALSE,
  ...,
  extra_cols = NULL,
  name = NULL
)
}
\arguments{
\item{location}{filepath, or \verb{:memory:}}

\item{embed}{A function that is called with a character vector and returns a
matrix of embeddings. Note this function will be serialized and then
deserialized in new R sessions, so it cannot reference to any objects in
the global or parent environments. Make sure to namespace all function
calls with \code{::}. If additional R objects must be available in the function,
you can optionally supply a \code{carrier::crate()} with packaged data.
It can also be \code{NULL} for stores that don't need to embed their texts, for example,
if only using FTS algorithms such as \code{\link[=ragnar_retrieve_bm25]{ragnar_retrieve_bm25()}}.}

\item{embedding_size}{integer}

\item{overwrite}{logical, what to do if \code{location} already exists}

\item{...}{Unused. Must be empty.}

\item{extra_cols}{A zero row data frame used to specify additional columns that
should be added to the store. Such columns can be used for adding additional
context when retrieving. See the examples for more information.
\code{\link[vctrs:vec_cast]{vctrs::vec_cast()}} is used to consistently perform type checks and casts
when inserting with \code{\link[=ragnar_store_insert]{ragnar_store_insert()}}.}

\item{name}{A unique name for the store. Must match the \verb{^[a-zA-Z0-9_-]+$}
regex. Used by \code{\link[=ragnar_register_tool_retrieve]{ragnar_register_tool_retrieve()}} for registering tools.}
}
\value{
a \code{DuckDBRagnarStore} object
}
\description{
Create and connect to a vector store
}
\examples{
# A store with a dummy embedding
store <- ragnar_store_create(
  embed = \(x) matrix(stats::runif(10), nrow = length(x), ncol = 10),
)
ragnar_store_insert(store, data.frame(text = "hello"))

# A store with a schema. When inserting into this store, users need to
# provide a `area` column.
store <- ragnar_store_create(
  embed = \(x) matrix(stats::runif(10), nrow = length(x), ncol = 10),
  extra_cols = data.frame(area = character()),
)
ragnar_store_insert(store, data.frame(text = "hello", area = "rag"))

# If you already have a data.frame with chunks that will be inserted into
# the store, you can quickly create a suitable store with:
chunks <- data.frame(text = letters, area = "rag")
store <- ragnar_store_create(
  embed = \(x) matrix(stats::runif(10), nrow = length(x), ncol = 10),
  extra_cols = vctrs::vec_ptype(chunks),
)
ragnar_store_insert(store, chunks)

}
