% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{infer_conforming_time_grid}
\alias{infer_conforming_time_grid}
\title{A time grid with extra times inserted for coupons, calls and puts}
\usage{
infer_conforming_time_grid(min_num_time_steps, Tmax, instruments = NULL)
}
\arguments{
\item{min_num_time_steps}{The minimum number of timesteps the output vector should have}

\item{Tmax}{The maximum time on the grid}

\item{instruments}{A set of instruments whose maturity and terms
and conditions can introduce extra timesteps.  Each will be queried for the output of
a \code{critical_times} function.}
}
\value{
A vector of times at which the grid should have nodes
}
\description{
At its base, this function chooses a time grid with \code{1+min_num_time_steps}
  elements from 0 to \code{Tmax}.  Any coupon, call, or put times occurring in
  one of the supplied instruments are also inserted.
}
\seealso{
Other Implicit Grid Solver: \code{\link{construct_implicit_grid_structure}},
  \code{\link{find_present_value}},
  \code{\link{form_present_value_grid}},
  \code{\link{integrate_pde}},
  \code{\link{iterate_grid_from_timestep}},
  \code{\link{take_implicit_timestep}},
  \code{\link{timestep_instruments}}
}

