#' @name raincpc
#'
#' @title Obtain and analyze rainfall data from the Climate Prediction Center.
#'
#' @details The Climate Prediction Center's (CPC) rainfall data for the
#' world (1979 to present, 50 km resolution) and the USA (1948 to
#' present, 25 km resolution), is one of the few high quality, long term,
#' observation based, daily rainfall products available for free. Although
#' raw data is available at CPC's ftp site, obtaining,
#' processing and visualizing the data is not straightforward. There are
#' thousands of files, and file formats and file extensions have been
#' changing over time. This package provides functionality to download,
#' process and visualize over 40 years of global rainfall data and over
#' 70 years of USA rainfall data from CPC.
#'
#' @import raster
#'
#' @docType package
#'
#' @author Gopi Goteti
#'
#' @references Climate Prediction Center's (CPC), \url{https://www.cpc.ncep.noaa.gov/},
#' daily rainfall data, ftp site \url{https://ftp.cpc.ncep.noaa.gov/precip/CPC_UNI_PRCP/}
NULL
