/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.conceptdrift.utils;

import eu.amidst.core.distribution.Normal;
import eu.amidst.core.exponentialfamily.EF_BaseDistribution_MultinomialParents;
import eu.amidst.core.exponentialfamily.EF_LearningBayesianNetwork;
import eu.amidst.core.exponentialfamily.EF_Normal;
import eu.amidst.core.exponentialfamily.EF_NormalParameter;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.learning.parametric.bayesian.utils.PlateuStructure;
import eu.amidst.core.learning.parametric.bayesian.utils.TransitionMethod;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.List;

public class GaussianHiddenTransitionMethod
implements TransitionMethod,
Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    List<Variable> localHiddenVars;
    double meanStart;
    double transtionVariance;
    double fading = 1.0;

    public void setTransitionVariance(double noise) {
        this.transtionVariance = noise;
    }

    public void setFading(double fading) {
        this.fading = fading;
    }

    public GaussianHiddenTransitionMethod(List<Variable> localHiddenVars_, double meanStart_, double transtionVariance_) {
        this.localHiddenVars = localHiddenVars_;
        this.meanStart = meanStart_;
        this.transtionVariance = transtionVariance_;
    }

    @Override
    public EF_LearningBayesianNetwork initModel(EF_LearningBayesianNetwork bayesianNetwork, PlateuStructure plateuStructure) {
        for (Variable paramVariable : bayesianNetwork.getParametersVariables().getListOfParamaterVariables()) {
            if (!paramVariable.isNormalParameter()) continue;
            EF_NormalParameter prior = (EF_NormalParameter)bayesianNetwork.getDistribution(paramVariable);
            double varPrior = 1.0;
            double precisionPrior = 1.0 / varPrior;
            double meanPrior = 0.0;
            prior.setNaturalWithMeanPrecision(meanPrior, precisionPrior);
            prior.fixNumericalInstability();
            prior.updateMomentFromNaturalParameters();
        }
        for (Variable localVar : this.localHiddenVars) {
            EF_Normal normal = (EF_Normal)bayesianNetwork.getDistribution(localVar);
            double mean = this.meanStart;
            double var = 1.0;
            normal.setNaturalWithMeanPrecision(mean, 1.0 / var);
            normal.fixNumericalInstability();
            normal.updateMomentFromNaturalParameters();
        }
        return bayesianNetwork;
    }

    @Override
    public EF_LearningBayesianNetwork transitionModel(EF_LearningBayesianNetwork bayesianNetwork, PlateuStructure plateuStructure) {
        for (Variable localVar : this.localHiddenVars) {
            Normal normalGlobalHiddenPreviousTimeStep = (Normal)((EF_UnivariateDistribution)plateuStructure.getEFParameterPosterior(localVar)).toUnivariateDistribution();
            EF_Normal normal = (EF_Normal)bayesianNetwork.getDistribution(localVar);
            double variance = normalGlobalHiddenPreviousTimeStep.getVariance() + this.transtionVariance;
            double mean = normalGlobalHiddenPreviousTimeStep.getMean();
            normal.setNaturalWithMeanPrecision(mean, 1.0 / variance);
            normal.fixNumericalInstability();
            normal.updateMomentFromNaturalParameters();
        }
        if (this.fading < 1.0) {
            bayesianNetwork.getParametersVariables().getListOfParamaterVariables().stream().forEach(var -> {
                EF_BaseDistribution_MultinomialParents dist = (EF_BaseDistribution_MultinomialParents)bayesianNetwork.getDistribution((Variable)var);
                EF_UnivariateDistribution prior = dist.getBaseEFUnivariateDistribution(0);
                NaturalParameters naturalParameters = prior.getNaturalParameters();
                naturalParameters.multiplyBy(this.fading);
                prior.setNaturalParameters(naturalParameters);
                dist.setBaseEFDistribution(0, prior);
            });
        }
        return bayesianNetwork;
    }
}

