/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream.filereaders.arffFileReader;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.filereaders.DataFileReader;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.datastream.filereaders.arffFileReader.ARFFDataReader;
import eu.amidst.core.datastream.filereaders.arffFileReader.DataRowWeka;
import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ARFFDataFolderReader
implements DataFileReader {
    String relationName;
    Attributes attributes;
    String pathFileName;
    String pathFileHeader;
    String pathFileData;

    @Override
    public void loadFromFile(String path) {
        this.pathFileData = path + "/data/";
        this.pathFileHeader = path + "/attributes.txt";
        this.pathFileName = path + "/name.txt";
        try {
            this.relationName = ((String)Files.lines(Paths.get(this.pathFileName, new String[0])).collect(Collectors.toList()).get(0)).split(" ")[1];
            Stream<String> headerLines = Files.lines(Paths.get(this.pathFileHeader, new String[0]));
            List attLines = headerLines.filter(w -> !w.isEmpty()).filter(w -> !w.startsWith("%")).filter(line -> line.startsWith("@attribute")).collect(Collectors.toList());
            List<Attribute> atts = null;
            try {
                atts = attLines.stream().map(line -> {
                    String[] parts = line.split(" |\t");
                    int index = Integer.parseInt(parts[2]);
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < parts.length; ++i) {
                        if (i == 2) continue;
                        builder.append(parts[i]);
                        builder.append("\t");
                    }
                    return ARFFDataReader.createAttributeFromLine(index, builder.toString());
                }).collect(Collectors.toList());
            }
            catch (Exception e) {
                atts = IntStream.range(0, attLines.size()).mapToObj(i -> ARFFDataReader.createAttributeFromLine(i, (String)attLines.get(i))).collect(Collectors.toList());
            }
            Collections.sort(atts, (a, b) -> a.getIndex() - b.getIndex());
            this.attributes = new Attributes(atts);
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean doesItReadThisFile(String fileName) {
        if (!new File(fileName).isDirectory()) {
            return false;
        }
        String[] parts = fileName.split("\\.");
        return parts[parts.length - 1].equals("arff");
    }

    @Override
    public Stream<DataRow> stream() {
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(this.pathFileData, new String[0]));
            Stream<Path> stream = StreamSupport.stream(directoryStream.spliterator(), false);
            Stream fileLines = stream.filter(path -> !path.getFileName().toString().startsWith(".")).flatMap(path -> {
                try {
                    return Files.lines(path);
                }
                catch (Exception ex) {
                    throw new UndeclaredThrowableException(ex);
                }
            });
            return fileLines.filter(w -> !w.isEmpty()).filter(w -> !w.startsWith("%")).map(line -> new DataRowWeka(this.attributes, (String)line));
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

