/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.inference.messagepassing;

import eu.amidst.core.inference.messagepassing.Node;
import eu.amidst.core.utils.Serialization;
import eu.amidst.core.utils.Vector;

public class Message<E extends Vector> {
    Node node;
    E vector;
    boolean done = false;

    public Message(Node node_) {
        this.node = node_;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public Node getNode() {
        return this.node;
    }

    public void setVector(E vector) {
        this.vector = vector;
    }

    public E getVector() {
        return this.vector;
    }

    public void combine(Message<E> m1) {
        if (m1.getNode().getMainVariable() != this.getNode().getMainVariable()) {
            throw new IllegalArgumentException();
        }
        this.getVector().sum((Vector)m1.vector);
        this.setDone(this.isDone() && m1.isDone());
    }

    public static <E extends Vector> Message<E> combineNonStateless(Message<E> m1, Message<E> m2) {
        if (m1.getNode().getMainVariable() != m2.getNode().getMainVariable()) {
            throw new IllegalArgumentException();
        }
        m1.getVector().sum((Vector)m2.vector);
        m1.setDone(m2.isDone() && m1.isDone());
        return m1;
    }

    public static <E extends Vector> Message<E> combineStateless(Message<E> m1, Message<E> m2) {
        if (m1.getNode().getMainVariable() != m2.getNode().getMainVariable()) {
            throw new IllegalArgumentException();
        }
        Message<Vector> newmessage = new Message<Vector>(m1.getNode());
        newmessage.setVector((Vector)Serialization.deepCopy(m1.getVector()));
        newmessage.getVector().sum((Vector)m2.vector);
        newmessage.setDone(m2.isDone() && m1.isDone());
        return newmessage;
    }
}

