/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.models;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.models.DAG;
import eu.amidst.core.models.ParentSet;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public final class BayesianNetwork
implements Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    private List<ConditionalDistribution> distributions;
    private DAG dag;

    public BayesianNetwork(DAG dag) {
        this.dag = dag;
        this.initializeDistributions();
    }

    public BayesianNetwork(DAG dag, List<ConditionalDistribution> dists) {
        this.dag = dag;
        this.distributions = dists;
    }

    public String getName() {
        return this.dag.getName();
    }

    public void setName(String name) {
        this.dag.setName(name);
    }

    public <E extends ConditionalDistribution> E getConditionalDistribution(Variable var) {
        return (E)this.distributions.get(var.getVarID());
    }

    public void setConditionalDistribution(Variable var, ConditionalDistribution dist) {
        this.distributions.set(var.getVarID(), dist);
    }

    public int getNumberOfVars() {
        return this.getDAG().getVariables().getNumberOfVars();
    }

    public Variables getVariables() {
        return this.getDAG().getVariables();
    }

    public DAG getDAG() {
        return this.dag;
    }

    public double[] getParameters() {
        int size = this.distributions.stream().mapToInt(dist -> dist.getNumberOfParameters()).sum();
        double[] param = new double[size];
        int count = 0;
        for (Distribution distribution : this.distributions) {
            System.arraycopy(distribution.getParameters(), 0, param, count, distribution.getNumberOfParameters());
            count += distribution.getNumberOfParameters();
        }
        return param;
    }

    private void initializeDistributions() {
        this.distributions = new ArrayList<ConditionalDistribution>(this.getNumberOfVars());
        for (Variable var : this.getVariables()) {
            ParentSet parentSet = this.getDAG().getParentSet(var);
            int varID = var.getVarID();
            this.distributions.add(varID, (ConditionalDistribution)var.newConditionalDistribution(parentSet.getParents()));
            parentSet.blockParents();
        }
    }

    public double getLogProbabiltyOf(Assignment assignment) {
        double logProb = 0.0;
        for (Variable var : this.getVariables()) {
            if (assignment.getValue(var) == Utils.missingValue()) {
                throw new UnsupportedOperationException("This method can not compute the probabilty of a partial assignment.");
            }
            logProb += this.distributions.get(var.getVarID()).getLogConditionalProbability(assignment);
        }
        return logProb;
    }

    public List<ConditionalDistribution> getConditionalDistributions() {
        return this.distributions;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Bayesian Network:\n");
        for (Variable var : this.getVariables()) {
            if (this.getDAG().getParentSet(var).getNumberOfParents() == 0) {
                str.append("P(" + var.getName() + ") follows a ");
                str.append(((Distribution)this.getConditionalDistribution(var)).label() + "\n");
            } else {
                str.append("P(" + var.getName() + " | ");
                for (Variable parent : this.getDAG().getParentSet(var)) {
                    str.append(parent.getName() + ", ");
                }
                str.delete(str.length() - 2, str.length());
                if (this.getDAG().getParentSet(var).getNumberOfParents() > 0) {
                    str.substring(0, str.length() - 2);
                    str.append(") follows a ");
                    str.append(((Distribution)this.getConditionalDistribution(var)).label() + "\n");
                }
            }
            str.append(((Distribution)this.getConditionalDistribution(var)).toString() + "\n");
        }
        return str.toString();
    }

    public void randomInitialization(Random random) {
        this.distributions.stream().forEach(w -> w.randomInitialization(random));
    }

    public boolean equalBNs(BayesianNetwork bnet, double threshold) {
        boolean equals = true;
        if (this.getDAG().equals(bnet.getDAG())) {
            for (Variable var : this.getVariables()) {
                equals = equals && ((Distribution)this.getConditionalDistribution(var)).equalDist((Distribution)bnet.getConditionalDistribution(var), threshold);
            }
        }
        return equals;
    }

    public static String listOptions() {
        return BayesianNetwork.classNameID();
    }

    public static String listOptionsRecursively() {
        return BayesianNetwork.listOptions() + "\n" + "test";
    }

    public static String classNameID() {
        return "BayesianNetwork";
    }

    public static void loadOptions() {
    }
}

