/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables.distributionTypes;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.ConditionalLinearGaussian;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.distribution.Normal_MultinomialNormalParents;
import eu.amidst.core.distribution.Normal_MultinomialParents;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.Variable;
import java.util.List;

public class NormalType
extends DistributionType {
    public NormalType(Variable variable) {
        super(variable);
    }

    @Override
    public boolean isParentCompatible(Variable parent) {
        return parent.getDistributionTypeEnum() == DistributionTypeEnum.MULTINOMIAL || parent.getDistributionTypeEnum() == DistributionTypeEnum.MULTINOMIAL_LOGISTIC || parent.getDistributionTypeEnum() == DistributionTypeEnum.NORMAL || parent.getDistributionTypeEnum() == DistributionTypeEnum.INDICATOR;
    }

    public Normal newUnivariateDistribution() {
        Normal normal = new Normal(this.variable);
        normal.setMean(0.0);
        normal.setVariance(1.0);
        return normal;
    }

    @Override
    public <E extends ConditionalDistribution> E newConditionalDistribution(List<Variable> parents) {
        if (!this.areParentsCompatible(parents)) {
            throw new IllegalArgumentException("Parents are not compatible");
        }
        boolean multinomialParents = false;
        boolean normalParents = false;
        for (Variable v : parents) {
            if (v.getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                multinomialParents = true;
                continue;
            }
            if (!v.isNormal()) continue;
            normalParents = true;
        }
        if (!multinomialParents && !normalParents) {
            return (E)new Normal(this.variable);
        }
        if (multinomialParents && !normalParents) {
            return (E)new Normal_MultinomialParents(this.variable, parents);
        }
        if (!multinomialParents && normalParents) {
            return (E)new ConditionalLinearGaussian(this.variable, parents);
        }
        if (multinomialParents && normalParents) {
            return (E)new Normal_MultinomialNormalParents(this.variable, parents);
        }
        return null;
    }
}

