% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convenience.R
\name{randn}
\alias{randn}
\title{Matrix/Array of Normal Random Numbers}
\usage{
randn(nrow = 1, ncol = 1, ..., mean = 0, sd = 1)
}
\arguments{
\item{nrow}{The desired number of rows.}

\item{ncol}{The desired number of columns.}

\item{...}{Further dimensions of the array.}

\item{mean}{Mean for the normal distribution. (\code{randn} only).}

\item{sd}{Standard deviation for the normal distribution.
  (\code{randn} only).}
}
\value{
A  matrix or array of pseudorandom numbers.
}
\description{
Construct a matrix or multi-way array of normal random deviates.
}
\examples{
randn(100, 100)  # 100 by 100 matrix of standard normal random variates
randn(2, 3, mean = 10, sd = 0.1)
}
\seealso{
\code{\link{rand}}, \code{\link{randi}}, \code{\link{rnorm}}.
}

