% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExpectation.R, R/normEndp.R, R/power.R, R/chronBias.R, R/selBias.R, R/combinedBias.R
\docType{methods}
\name{getExpectation}
\alias{getExpectation}
\alias{getExpectation,randSeq,chronBias,missing-method}
\alias{getExpectation,randSeq,chronBias,normEndp-method}
\alias{getExpectation,randSeq,combinedBias,normEndp-method}
\alias{getExpectation,randSeq,combinedBiasStepTrend,normEndp-method}
\alias{getExpectation,randSeq,missing,normEndp-method}
\alias{getExpectation,randSeq,power,normEndp-method}
\alias{getExpectation,randSeq,selBias,missing-method}
\alias{getExpectation,randSeq,selBias,normEndp-method}
\title{Get expectations of a randomization list}
\usage{
getExpectation(randSeq, issue, endp)

\S4method{getExpectation}{randSeq,missing,normEndp}(randSeq, endp)

\S4method{getExpectation}{randSeq,power,normEndp}(randSeq, issue, endp)

\S4method{getExpectation}{randSeq,chronBias,normEndp}(randSeq, issue, endp)

\S4method{getExpectation}{randSeq,chronBias,missing}(randSeq, issue)

\S4method{getExpectation}{randSeq,selBias,normEndp}(randSeq, issue, endp)

\S4method{getExpectation}{randSeq,selBias,missing}(randSeq, issue)

\S4method{getExpectation}{randSeq,combinedBias,normEndp}(randSeq, issue, endp)

\S4method{getExpectation}{randSeq,combinedBiasStepTrend,normEndp}(randSeq,
  issue, endp)
}
\arguments{
\item{randSeq}{object of the class randSeq.}

\item{issue}{object of the class issue (optional).}

\item{endp}{object of the class endpoint (optional).}
}
\description{
Generates a matrix of the expectations of the included patients in the 
clinical trial.
}
\details{
It is assumed that the expectations of the included patients in a clinical trial
can be influenced in three different ways:
\itemize{
\item The strength of selection bias and the guessing strategy
of the investigator (see \code{\link{selBias}}).
\item The strength of a linear time trend, which is described by an object
 of the class \code{\link{chronBias}}.
\item The expectations of the investigated treatement groups can be different 
(see e.g. \code{\link{normEndp}}).
}
}
\examples{
myPar <- bsdPar(10, 2)
M <- genSeq(myPar, 2)
cs <- selBias("CS", 2, "sim")
endp <- normEndp(mu = c(2, 2), sigma = c(1, 1))
getExpectation(M, cs, endp)

}

