% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issue.R
\name{issue}
\alias{issue}
\alias{issues}
\title{Assessment criteria for clinical trials}
\description{
Summarizes the criteria for the assessment of randomization procedures.
}
\details{
Randomization in clinical trials is supposed to 
control certain properties in clinical trials. In the randomizeR package, 
these properties are called \code{issues}.
It is crucial to decide which of the issues is relevant in the present 
clinical trial, because a randomization procedure that manages well one issue
might behave very badly for another. The issues include
\itemize{
\item \strong{Selection bias} 
		can occur if future treatment allocations are predictable due to 
		restricted randomization and unmasking of past treatment assignments.
	The influence of selection bias on the test decision is represented by 
	the \code{\link{selBias}} class. The measure for the predictability of
	a randomization procedure is implemented in the \code{\link{corGuess}} class
	representing the expected number of correct guesses.
\item \strong{Chronological bias} 
		can occur if a time trend is present in the data. Time trends occur
		due to learning curves, relaxed inclusion/ exclusion criteria or
   new co-medication.
	Chronological bias is represented by the \code{\link{chronBias}} class.
\item \strong{Additive combination of chronological and selection bias} 
		may occur if a time trend and selection bias are present in the data.
	The combined bias is represented by the \code{\link{combineBias}} class.
\item \strong{Balance}
		is important in order to ensure proper power estimation properties of
   the treatments.
		However, a high degree of balance favors selection bias. Depending on the
		clinical context, a randomization procedure should be chosen that admits 
		a suitable imbalance.
	Imbalance bias is represented by the \code{\link{imbal}} class. The power
	loss due to imbalance can be assessed directly via the \code{\link{setPower}}
	class
}
}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

Assessment of randomization sequences: \code{\link{assess}}

Comparison of randomization sequences: \code{\link{compare}}

Other issues: 
\code{\link{chronBias}},
\code{\link{combineBias}()},
\code{\link{corGuess}},
\code{\link{imbal}},
\code{\link{selBias}},
\code{\link{setPower}()}
}
\concept{issues}
