% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/randomizr.r
\name{simple_ra}
\alias{simple_ra}
\title{Simple Random Assignment}
\usage{
simple_ra(N, prob = NULL, num_arms = NULL, prob_each = NULL,
  condition_names = NULL)
}
\arguments{
\item{N}{the total number of units in the experimental sample}

\item{prob}{if specified, a two-group design is assumed. prob is the probability of assignment to treatment.}

\item{num_arms}{the total number of treatment arms. If unspecified, will be determined from the length of prob_each or condition_names.}

\item{prob_each}{a numeric vector giving probabilites of assignment to each treatment group. Must sum to 1. If unspecified, equal probabilities will be assumed.}

\item{condition_names}{a character vector giving the names of the treatment groups.  If unspecified, the treatment groups will be names T1, T2, T3, etc.}
}
\description{
This function conducts simple random assignment, a procedure in which units are assigned to treatment conditions with a known probability, but the number of units assigned to any condition might vary from one randomization to the next.  This function can accomodate any number of treatment arms.
}
\examples{
# Two Group Designs

Z <- simple_ra(N=100)
table(Z)

Z <- simple_ra(N=100, prob=0.5)
table(Z)

Z <- simple_ra(N=100, prob_each = c(0.3, 0.7),
               condition_names = c("control", "treatment"))
table(Z)

# Multi-arm Designs
Z <- simple_ra(N=100, num_arms=3)
table(Z)

Z <- simple_ra(N=100, prob_each=c(0.3, 0.3, 0.4))
table(Z)

Z <- simple_ra(N=100, prob_each=c(0.3, 0.3, 0.4),
               condition_names=c("control", "placebo", "treatment"))
table(Z)

Z <- simple_ra(N=100, condition_names=c("control", "placebo", "treatment"))
table(Z)
}
\keyword{assignment}
\keyword{random}

