% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapPlot-methods.R
\docType{methods}
\name{plot,SpatialPixelsRangeMap,missing-method}
\alias{plot,SpatialPixelsRangeMap,missing-method}
\title{Plot a SpatialPixelsRangeMap}
\usage{
\S4method{plot}{SpatialPixelsRangeMap,missing}(x,
  colorpalette = brewer.pal.get("Spectral")[11:1], ncols = 20,
  scales = FALSE, style = "equal", ...)
}
\arguments{
\item{x}{a \code{SpatialPixelsRangeMap}.}

\item{colorpalette}{a color palette.}

\item{ncols}{number of color classes required, default to 20; argument to be passed to
\code{\link[classInt]{classIntervals}}.}

\item{scales}{ff \sQuote{FALSE}, the default, axes scale are not drawn.}

\item{style}{class interval style; see \code{\link[classInt]{classIntervals}} for more details.}

\item{\dots}{any argument that can be passed to see \code{\link[sp]{spplot}}}
}
\description{
This is a wrapper around \code{spplot}
}
\examples{
breding_ranges = rgdal::readOGR(system.file(package = "rangeMapper",
     "extdata", "wrens", "vector_combined"), "wrens", verbose = FALSE)[1:10, ]
data(wrens)
d = subset(wrens, select = c('sci_name', 'body_size', 'body_mass', 'clutch_size') )
con = ramp("wrens.sqlite", gridSize = 10, spdf = breding_ranges, biotab = d, ID = "sci_name",
            metadata = rangeTraits(), FUN = "median", overwrite = TRUE)
all = rangeMap.fetch(con)
sr = rangeMap.fetch(con, 'species_richness')
plot(sr)
plot(all)
}
\seealso{
\code{\link{plot,rmap.frame,missing-method}}.
}

