% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioSave-methods.R
\name{bio.save}
\alias{bio.save}
\alias{bio.merge}
\alias{metadata2bio}
\title{Import \sQuote{BIO} tables to a \code{rangeMapper} project.}
\usage{
bio.save(con, loc, tableName, ...)

bio.merge(con, tableName, ...)

metadata2bio(con, ...)
}
\arguments{
\item{con}{an sqlite connection pointing to a valid \code{rangeMapper}
project.}

\item{loc}{file location or \code{data.frame} name.}

\item{tableName}{if missing, the name of the file or \code{data.frame} is used}

\item{\dots}{arguments to pass to the corresponding methods: e.g. the ID,
the column corresponding to the names of the range files}
}
\value{
a \sQuote{BIO} table is created in the corresponding
                 \code{rangeMapper} project.
}
\description{
Import tables (e.g. life history data) to an active \code{rangeMapper}
project.
}
\examples{

require(rangeMapper)
require(rgdal)
wd = setwd(tempdir())
r = readOGR(system.file(package = "rangeMapper",
	"extdata", "wrens", "vector_combined"), "wrens", verbose = FALSE)
dbcon = rangeMap.start(file = "wrens.sqlite", overwrite = TRUE,
	dir = tempdir() )
global.bbox.save(con = dbcon, bbox = r)
gridSize.save(dbcon, gridSize = 2)
canvas.save(dbcon)
processRanges(spdf = r, con =  dbcon, ID = "sci_name" )

# Upload BIO tables
data(wrens)
Troglodytes  = wrens[grep("Troglodytes", wrens$sci_name), c(2, 5)]
bio.save(con = dbcon, loc = Troglodytes,  ID = "sci_name")

setwd(wd)


\dontrun{
require(rangeMapper)
require(rgdal)
wd = setwd(tempdir())
r = readOGR(system.file(package = "rangeMapper",
  "extdata", "wrens", "vector_combined"), "wrens", verbose = FALSE)
dbcon = rangeMap.start(file = "wrens.sqlite", overwrite = TRUE,
	dir = tempdir() )
global.bbox.save(con = dbcon, bbox = r)
gridSize.save(dbcon, gridSize = 2)
canvas.save(dbcon)
processRanges(spdf = r, con =  dbcon, ID = "sci_name", metadata = rangeTraits() )

wrensPath = system.file(package = "rangeMapper", "data", "wrens.csv")
bio.save(con = dbcon, loc = wrensPath,  ID = "sci_name")
bio.merge(dbcon, "wrensNew")
metadata2bio(dbcon)
setwd(wd)

}


}
