% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AttributeSpace.R
\name{AttributeSpace}
\alias{AttributeSpace}
\title{Create new AttributeSpace object}
\usage{
AttributeSpace(planning.unit.points, demand.points, species)
}
\arguments{
\item{planning.unit.points}{\code{\link{PlanningUnitPoints}} for planning
unit in the space.}

\item{demand.points}{\code{\link{DemandPoints}} object for the space.}

\item{species}{\code{integer} species id to indicate which species the space
is associated with.}
}
\description{
This function creates a new \code{AttributeSpace} object.
}
\examples{
space <- AttributeSpace(
 PlanningUnitPoints(
   matrix(rnorm(100), ncol = 2),
   seq_len(50)),
 DemandPoints(
   matrix(rnorm(100), ncol = 2),
   runif(50)),
 species = 1L)

}
\seealso{
\code{\link{DemandPoints-class}},
  \code{\link{PlanningUnitPoints-class}}.
}
