% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simulated_data}
\alias{simulated_data}
\alias{sim_ru}
\alias{sim_rs}
\title{Simulated dataset for a conservation planning exercise}
\format{
\describe{
\item{sim_ru}{\code{\link[=RapUnsolved]{RapUnsolved()}} object with all the simulated data.}
\item{sim_rs}{\code{\link[=RapSolved]{RapSolved()}} object with 5 near-optimal solutions.}
}
}
\description{
This dataset contains all the data needed to generate prioritizations for
three simulated species. This dataset contains planning units, species
distribution maps, and demand points for each species. For the purposes of
exploring the behaviour of the problem, demand points were generated using
the centroids of planning units and the probability that they are occupied
by the species. Note that methodology is not encouraged for real-world
conservation planning.
}
\details{
The species were simulated to represent various simplified species
distributions.

\describe{
\item{uniform}{This species has an equal probability (0.5) of occurring in
all planning units.}
\item{normal}{This species has a single range-core where it is most likely
to be found. It is less likely to be found in areas further
away from the center of its range.}
\item{bimodal}{This species has two distinct ecotypes. Each ecotype has its
own core and marginal area.}
}
}
\examples{
# load data
data(sim_ru, sim_rs)

# plot species distributions
spp.plot(sim_ru, 1)
spp.plot(sim_ru, 2)
spp.plot(sim_ru, 3)

# plot selection frequencies
plot(sim_rs)

# plot best solution
plot(sim_rs, 0)
}
\keyword{datasets}
