% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.cv.R
\name{rarefit.cv}
\alias{rarefit.cv}
\title{Perform K-fold cross validation}
\usage{
rarefit.cv(fitObj, y, X, errtype = "mean-squared-error", nfolds = 5, ...)
}
\arguments{
\item{fitObj}{Output of \code{rarefit}}

\item{y}{Response variable.}

\item{X}{\code{nobs}-by-\code{nvars} input matrix:
each row is an observation vector and each column stores
a count covariate.}

\item{errtype}{Type of error metric used in cross validation.
Available choices are \emph{mean-squared-error} (default)
and \emph{mean-absolute-error}.}

\item{nfolds}{Number of folds (default is 5)}

\item{...}{Other arguments that can be passed to \code{rarefit}}
}
\value{
\item{folds}{A length-\code{nfolds} list with the kth element being elements in the \code{k}th fold.}
\item{errs}{A \code{nlam}-by-\code{nalpha}-by-\code{nfolds} 3-dimensional array of errors.
\code{errs[i,j,k]} is error incurred in using \code{lambda[i]} and \code{alpha[j]} on the \code{k}th fold.}
\item{m}{A \code{nlam}-by-\code{nalpha} matrix for storing CV error (i.e., mean error across folds).
\code{m[i,j]} is CV error incurred in using \code{lambda[i]} and \code{alpha[j]}.}
\item{se}{A \code{nlam}-by-\code{nalpha} matrix for storing standard error across folds.
\code{se[i,j]} is standard error incurred in using \code{lambda[i]} and \code{alpha[j]}.}
\item{ibest}{Indices of pair of (\code{lambda}, \code{alpha}) minimizing CV error.}
\item{lambda.best}{Value of \code{lambda} minimizing CV error.}
\item{alpha.best}{Value of \code{alpha} minimizing CV error.}
}
\description{
The function does K-fold cross validaton (CV) to choose an optimal pair of (\code{lambda}, \code{alpha})
on which the model performs best according to the chosen error metric: mean squared error
or mean absolute error.
}
\examples{
\dontrun{
# See vignette for more details.
set.seed(100)
ts <- sample(1:length(data.rating), 400) # Train set indices
# Fit the model on train set
ourfit <- rarefit(y = data.rating[ts], X = data.dtm[ts, ], hc = data.hc, lam.min.ratio = 1e-6,
                  nlam = 20, nalpha = 10, rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
# Cross validation
ourfit.cv <- rarefit.cv(ourfit, y = data.rating[ts], X = data.dtm[ts, ],
                        rho = 0.01, eps1 = 1e-5, eps2 = 1e-5, maxite = 1e4)
}

}
\seealso{
\code{\link{rarefit}}, \code{\link{rarefit.predict}}
}
