% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{save_yaml}
\alias{save_yaml}
\title{Write named list to file}
\usage{
save_yaml(x, file, ...)
}
\arguments{
\item{x}{a named list, \code{\link[dipsaus]{fastmap2}}, or anything
that can be transformed into named list via \code{as.list}}

\item{file, ...}{passed to \code{\link[yaml]{write_yaml}}}
}
\value{
Normalized file path
}
\description{
Write named list to file
}
\examples{


x <- list(a = 1, b = 2)
f <- tempfile()

save_yaml(x, f)

load_yaml(f)

map <- dipsaus::fastmap2(missing_default = NA)
map$c <- 'lol'
load_yaml(f, map = map)

map$a
map$d


}
\seealso{
\code{\link[dipsaus]{fastmap2}}, \code{\link{load_yaml}},
\code{\link[yaml]{read_yaml}}, \code{\link[yaml]{write_yaml}},
}
