% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rave-raw.R
\docType{data}
\name{rave-raw-validation}
\alias{rave-raw-validation}
\alias{validate_raw_file}
\alias{IMPORT_FORMATS}
\title{Validate raw files in 'rave' directory}
\format{
An object of class \code{list} of length 7.
}
\usage{
validate_raw_file(
  subject_code,
  blocks,
  electrodes,
  format,
  data_type = c("continuous"),
  ...
)

IMPORT_FORMATS
}
\arguments{
\item{subject_code}{subject code, direct folder under 'rave' raw data path}

\item{blocks}{block character, direct folder under subject folder. For raw
files following 'BIDS' convention, see details}

\item{electrodes}{electrodes to verify}

\item{format}{integer or character. For characters, run
\code{names(IMPORT_FORMATS)}}

\item{data_type}{currently only support continuous type of signals}

\item{...}{other parameters used if validating \code{'BIDS'} format; see
details.}
}
\value{
logical true or false whether the directory is valid. Attributes
containing error reasons or snapshot of the data. The attributes might be:
\item{\code{snapshot}}{description of data found if passing the
validation}
\item{\code{valid_run_names}}{For 'BIDS' format, valid
\code{session+task+run} name if passing the validation}
\item{\code{reason}}{named list where the names are the
reason why validation fails and values are corresponding sessions
or electrodes or both.}
}
\description{
Validate subjects and returns whether the subject can be
imported into 'rave'
}
\details{
Six types of raw file structures are supported. They can be basically
classified into two categories: 'rave' native raw structure and
'BIDS-iEEG' structure.

In 'rave' native structure, subject folders
are stored within the root directory, which can be obtained via
\code{raveio_getopt('raw_data_dir')}. Subject directory is the subject code.
Inside of subject folder are block files. In 'rave', term 'block'
is the combination of session, task, and run. Within each block, there
should be 'iEEG' data files.

In 'BIDS-iEEG' format, the root directory can be obtained via
\code{raveio_getopt('bids_data_dir')}. 'BIDS' root folder contains
project folders. This is unlike 'rave' native raw data format.
Subject folders are stored within the project directories.
The subject folders start with \code{'sub-'}. Within subject
folder, there are session folders with prefix \code{'ses-'}. Session
folders are optional. 'iEEG' data is stored in \code{'ieeg'} folder under
the session/subject folder. \code{'ieeg'} folder should contain at least
\describe{
\item{electrodes.tsv}{
  \code{sub-<label>*_electrodes.tsv}
}
\item{'iEEG' description}{
  \code{sub-<label>*_task-<label>_run-<index>_ieeg.json}
}
\item{'iEEG' data file}{
  \code{sub-<label>*_task-<label>_run-<index>_ieeg.<ext>}, in current
  'rave', only extensions \code{'.vhdr+.eeg/.dat'} ('BrainVision') or 'EDF'
  (or plus) are supported.
}
}
When format is 'BIDS', \code{project_name} must be specified.

The following formats are supported:
\describe{
\item{\code{'.mat/.h5 file per electrode per block'}}{
  'rave' native raw format, each block folder contains multiple
  'Matlab' or 'HDF5' files. Each file corresponds to a channel/electrode.
  File names should follow \code{'xxx001.mat'} or \code{'xxx001.h5'}. The
  numbers before the extension are channel numbers.
}
\item{\code{'Single .mat/.h5 file per block'}}{
  'rave' native raw format, each block folder contains \strong{only} one
  'Matlab' or 'HDF5' file. The file name can be arbitrary, but extension
  must be either \code{'.mat'} or \code{'.h5'}. Within the file there should
  be a matrix containing all the data. The short dimension of the matrix
  will be channels, and larger side of the dimension corresponds to the
  time points.
}
\item{\code{'Single EDF(+) file per block'}}{
  'rave' native raw format, each block folder contains \strong{only} one
  \code{'.edf'} file.
}
\item{\code{'Single BrainVision file (.vhdr+.eeg, .vhdr+.dat) per block'}}{
  'rave' native raw format, each block folder contains \strong{only} two
  files. The first file is header \code{'.vhdr'} file. It contains
  all meta information. The second is either \code{'.eeg'} or \code{'.dat'}
  file containing the body, i.e. signal entries.
}
\item{\code{'BIDS & EDF(+)'}}{
  'BIDS' format. The data file should have \code{'.edf'} extension
}
\item{\code{'BIDS & BrainVision (.vhdr+.eeg, .vhdr+.dat)'}}{
  'BIDS' format. The data file should have \code{'.vhdr'+'.eeg/.dat'}
  extensions
}
}
}
\keyword{datasets}
