% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-pipeline_tools.R
\name{PipelineTools}
\alias{PipelineTools}
\title{Class definition for pipeline tools}
\value{
The value of the inputs, or a list if \code{key} is missing

The values of the targets

A \code{\link{PipelineResult}} instance if \code{as_promise}
or \code{async} is true; otherwise a list of values for input \code{names}

An environment of shared variables

See \code{type}

A table of the progress

Nothing

A new pipeline object based on the path given

the saved file path

the data if file is found or a default value
}
\description{
Class definition for pipeline tools

Class definition for pipeline tools
}
\seealso{
\code{\link{pipeline}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{settings_path}}{absolute path to the settings file}

\item{\code{extdata_path}}{absolute path to the user-defined pipeline data folder}

\item{\code{target_table}}{table of target names and their descriptions}

\item{\code{result_table}}{summary of the results, including
signatures of data and commands}

\item{\code{pipeline_path}}{the absolute path of the pipeline}

\item{\code{pipeline_name}}{the code name of the pipeline}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipelineTools-new}{\code{PipelineTools$new()}}
\item \href{#method-PipelineTools-set_settings}{\code{PipelineTools$set_settings()}}
\item \href{#method-PipelineTools-get_settings}{\code{PipelineTools$get_settings()}}
\item \href{#method-PipelineTools-read}{\code{PipelineTools$read()}}
\item \href{#method-PipelineTools-run}{\code{PipelineTools$run()}}
\item \href{#method-PipelineTools-eval}{\code{PipelineTools$eval()}}
\item \href{#method-PipelineTools-shared_env}{\code{PipelineTools$shared_env()}}
\item \href{#method-PipelineTools-python_module}{\code{PipelineTools$python_module()}}
\item \href{#method-PipelineTools-progress}{\code{PipelineTools$progress()}}
\item \href{#method-PipelineTools-attach}{\code{PipelineTools$attach()}}
\item \href{#method-PipelineTools-visualize}{\code{PipelineTools$visualize()}}
\item \href{#method-PipelineTools-fork}{\code{PipelineTools$fork()}}
\item \href{#method-PipelineTools-with_activated}{\code{PipelineTools$with_activated()}}
\item \href{#method-PipelineTools-clean}{\code{PipelineTools$clean()}}
\item \href{#method-PipelineTools-save_data}{\code{PipelineTools$save_data()}}
\item \href{#method-PipelineTools-load_data}{\code{PipelineTools$load_data()}}
\item \href{#method-PipelineTools-clone}{\code{PipelineTools$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-new}{}}}
\subsection{Method \code{new()}}{
construction function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$new(
  pipeline_name,
  settings_file = "settings.yaml",
  paths = pipeline_root(),
  temporary = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pipeline_name}}{name of the pipeline, usually in the pipeline
\code{'DESCRIPTION'} file, or pipeline folder name}

\item{\code{settings_file}}{the file name of the settings file, where the
user inputs are stored}

\item{\code{paths}}{the paths to find the pipeline, usually the parent folder
of the pipeline; default is \code{pipeline_root()}}

\item{\code{temporary}}{whether not to save \code{paths} to current pipeline
root registry. Set this to \code{TRUE} when importing pipelines
from subject pipeline folders}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-set_settings"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-set_settings}{}}}
\subsection{Method \code{set_settings()}}{
set inputs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$set_settings(..., .list = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{..., .list}}{named list of inputs; all inputs should be named,
otherwise errors will be raised}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-get_settings"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-get_settings}{}}}
\subsection{Method \code{get_settings()}}{
get current inputs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$get_settings(key, default = NULL, constraint)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{the input name; default is missing, i.e., to get all the
settings}

\item{\code{default}}{default value if not found}

\item{\code{constraint}}{the constraint of the results; if input value is not
from \code{constraint}, then only the first element of \code{constraint}
will be returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-read"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-read}{}}}
\subsection{Method \code{read()}}{
read intermediate variables
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$read(var_names, ifnotfound = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var_names}}{the target names, can be obtained via
\code{x$target_table} member; default is missing, i.e., to read
all the intermediate variables}

\item{\code{ifnotfound}}{variable default value if not found}

\item{\code{...}}{other parameters passing to \code{\link{pipeline_read}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-run"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-run}{}}}
\subsection{Method \code{run()}}{
run the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$run(
  names = NULL,
  async = FALSE,
  as_promise = async,
  scheduler = c("none", "future", "clustermq"),
  type = c("smart", "callr", "vanilla"),
  envir = new.env(parent = globalenv()),
  callr_function = NULL,
  return_values = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{pipeline variable names to calculate; default is to
calculate all the targets}

\item{\code{async}}{whether to run asynchronous in another process}

\item{\code{as_promise}}{whether to return a \code{\link{PipelineResult}}
instance}

\item{\code{scheduler, type, envir, callr_function, return_values, ...}}{passed to
\code{\link{pipeline_run}} if \code{as_promise} is true, otherwise
these arguments will be passed to \code{pipeline_run_bare}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-eval"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-eval}{}}}
\subsection{Method \code{eval()}}{
run the pipeline in order; unlike \code{$run()}, this method
does not use the \code{targets} infrastructure, hence the pipeline
results will not be stored, and the order of \code{names} will be
respected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$eval(names, env = parent.frame(), clean = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{pipeline variable names to calculate; must be specified}

\item{\code{env}}{environment to evaluate and store the results}

\item{\code{clean}}{whether to evaluate without polluting \code{env}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-shared_env"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-shared_env}{}}}
\subsection{Method \code{shared_env()}}{
run the pipeline shared library in scripts starting with
path \code{R/shared}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$shared_env()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-python_module"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-python_module}{}}}
\subsection{Method \code{python_module()}}{
get 'Python' module embedded in the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$python_module(
  type = c("info", "module", "shared", "exist"),
  must_work = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{return type, choices are \code{'info'} (get basic information
such as module path, default), \code{'module'} (load module and return
it), \code{'shared'} (load a shared sub-module from the module, which
is shared also in report script), and \code{'exist'} (returns true
or false on whether the module exists or not)}

\item{\code{must_work}}{whether the module needs to be existed or not. If
\code{TRUE}, the raise errors when the module does not exist; default
is \code{TRUE}, ignored when \code{type} is \code{'exist'}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-progress"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-progress}{}}}
\subsection{Method \code{progress()}}{
get progress of the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$progress(method = c("summary", "details"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{either \code{'summary'} or \code{'details'}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-attach"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-attach}{}}}
\subsection{Method \code{attach()}}{
attach pipeline tool to environment (internally used)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$attach(env)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{env}}{an environment}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-visualize"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-visualize}{}}}
\subsection{Method \code{visualize()}}{
visualize pipeline target dependency graph
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$visualize(
  glimpse = FALSE,
  aspect_ratio = 2,
  node_size = 30,
  label_size = 40,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{glimpse}}{whether to glimpse the graph network or render the state}

\item{\code{aspect_ratio}}{controls node spacing}

\item{\code{node_size, label_size}}{size of nodes and node labels}

\item{\code{...}}{passed to \code{\link{pipeline_visualize}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-fork"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-fork}{}}}
\subsection{Method \code{fork()}}{
fork (copy) the current pipeline to a new directory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$fork(path, filter_pattern = PIPELINE_FORK_PATTERN)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path to the new pipeline, a folder will be created there}

\item{\code{filter_pattern}}{file pattern to copy}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-with_activated"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-with_activated}{}}}
\subsection{Method \code{with_activated()}}{
run code with pipeline activated, some environment variables
and function behaviors might change under such condition (for example,
\code{targets} package functions)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$with_activated(expr, quoted = FALSE, env = parent.frame())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{expression to evaluate}

\item{\code{quoted}}{whether \code{expr} is quoted; default is false}

\item{\code{env}}{environment to run \code{expr}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-clean"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-clean}{}}}
\subsection{Method \code{clean()}}{
clean all or part of the data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$clean(
  destroy = c("all", "cloud", "local", "meta", "process", "progress", "objects",
    "scratch", "workspaces"),
  ask = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{destroy, ask}}{see \code{\link[targets]{tar_destroy}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-save_data"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-save_data}{}}}
\subsection{Method \code{save_data()}}{
save data to pipeline data folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$save_data(
  data,
  name,
  format = c("json", "yaml", "csv", "fst", "rds"),
  overwrite = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{R object}

\item{\code{name}}{the name of the data to save, must start with letters}

\item{\code{format}}{serialize format, choices are \code{'json'},
\code{'yaml'}, \code{'csv'}, \code{'fst'}, \code{'rds'}; default is
\code{'json'}. To save arbitrary objects such as functions or
environments, use \code{'rds'}}

\item{\code{overwrite}}{whether to overwrite existing files; default is no}

\item{\code{...}}{passed to saver functions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-load_data"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-load_data}{}}}
\subsection{Method \code{load_data()}}{
load data from pipeline data folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$load_data(
  name,
  error_if_missing = TRUE,
  default_if_missing = NULL,
  format = c("auto", "json", "yaml", "csv", "fst", "rds"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{the name of the data}

\item{\code{error_if_missing}}{whether to raise errors if the name is missing}

\item{\code{default_if_missing}}{default values to return if the name is missing}

\item{\code{format}}{the format of the data, default is automatically obtained
from the file extension}

\item{\code{...}}{passed to loader functions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipelineTools-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipelineTools-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipelineTools$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
