% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-BlackrockFile.R
\name{convert_blackrock}
\alias{convert_blackrock}
\title{Convert 'BlackRock' 'NEV/NSx' files}
\usage{
convert_blackrock(
  file,
  block = NULL,
  subject = NULL,
  to = NULL,
  epoch = c("comment", "digital_inputs", "recording", "configuration", "log",
    "button_trigger", "tracking", "video_sync"),
  format = c("mat", "hdf5"),
  header_only = FALSE,
  ...
)
}
\arguments{
\item{file}{path to any 'NEV/NSx' file}

\item{block}{the block name, default is file name}

\item{subject}{subject code to save the files; default is \code{NULL}}

\item{to}{save to path, must be a directory; default is under the file path.
If \code{subject} is provided, then the default is \code{subject} raw
directory path}

\item{epoch}{what type of events should be included in epoch file; default
include comment, digital inputs, recording trigger, configuration change,
log comment, button trigger, tracking, and video trigger.}

\item{format}{output format, choices are \code{'mat'} or \code{'hdf5'}}

\item{header_only}{whether just to generate channel and epoch table; default
is false}

\item{...}{ignored for enhanced backward compatibility}
}
\value{
The results will be stored in directory specified by \code{to}.
Please read the output message carefully.
}
\description{
Convert 'BlackRock' 'NEV/NSx' files
}
