% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_title.R
\name{add_title}
\alias{add_title}
\title{Add Title}
\usage{
add_title(
  image,
  title_text = "",
  title_offset = c(15, 15),
  title_color = "black",
  title_size = 30,
  title_font = "sans",
  title_style = "normal",
  title_bar_color = NULL,
  title_bar_alpha = 0.5,
  title_bar_width = NULL,
  title_position = "northwest",
  filename = NULL,
  preview = FALSE
)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{title_text}{Default \code{NULL}. Text. Adds a title to the image, using \code{magick::image_annotate()}.}

\item{title_offset}{Default \code{c(15,15)}. Distance from the top-left (default, \code{gravity} direction in
image_annotate) corner to offset the title.}

\item{title_color}{Default \code{black}. Font color.}

\item{title_size}{Default \code{30}. Font size in pixels.}

\item{title_font}{Default \code{sans}. String with font family such as "sans", "mono", "serif", "Times", "Helvetica",
"Trebuchet", "Georgia", "Palatino" or "Comic Sans".}

\item{title_style}{Default \code{normal}. Font style (e.g. \code{italic}).}

\item{title_bar_color}{Default \code{NULL}. If a color, this will create a colored bar under the title.}

\item{title_bar_alpha}{Default \code{0.5}. Transparency of the title bar.}

\item{title_bar_width}{Default \code{NULL}, automaticly calculated from the size of the text and
the number of line breaks. Width of the title bar in pixels.}

\item{title_position}{Default \code{northwest}. Position of the title.}

\item{filename}{Default \code{NULL}. File to save the image to. If \code{NULL} and \code{preview = FALSE},
returns an RGB array.}

\item{preview}{Default \code{FALSE}. If \code{TRUE}, it will display the image in addition
to returning it.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and adds a title with an optional titlebar.
}
\examples{
if(rayimage:::run_documentation()){
#Plot the dragon
add_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20)
}
if(rayimage:::run_documentation()){
#That's hard to see--let's add a title bar:
add_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20,
         title_bar_color="white")
}
if(rayimage:::run_documentation()){
#Change the width of the bar:
add_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20,
         title_bar_color="white", title_offset = c(12,12))
}
if(rayimage:::run_documentation()){
#The width of the bar will also automatically adjust for newlines:
add_title(dragon, preview = TRUE, title_text = "Dragon\n(Blue)", title_size=20,
         title_bar_color="white", title_offset = c(12,12))
}
if(rayimage:::run_documentation()){
#Change the color and title color:
add_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20,
         title_bar_color="red", title_color = "white", title_offset = c(12,12))
}
if(rayimage:::run_documentation()){
#Change the transparency:
add_title(dragon, preview = TRUE, title_text = "Dragon", title_size=20, title_bar_alpha = 0.8,
         title_bar_color="red", title_color = "white", title_offset = c(12,12))
}
}
