% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_convolution.R
\name{render_convolution}
\alias{render_convolution}
\title{Render Convolution}
\usage{
render_convolution(
  image,
  kernel = "gaussian",
  kernel_dim = 11,
  kernel_extent = 3,
  absolute = TRUE,
  min_value = NULL,
  filename = NULL,
  preview = FALSE,
  gamma_correction = FALSE,
  progress = FALSE
)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{kernel}{Default \code{gaussian}. By default, an 11x11 Gaussian kernel with a mean
of \code{0} and a standard deviation of \code{1}, running from \code{-kernel_extent} to \code{kernel_extent}.
If numeric, this will be the standard deviation of the normal distribution. If a
matrix, it will be used directly as the convolution kernel (but resized always to be an odd number
of columns and rows).}

\item{kernel_dim}{Default \code{11}. The dimension of the \code{gaussian} kernel. Ignored
if user specifies their own kernel.}

\item{kernel_extent}{Default \code{3}. Extent over which to calculate the kernel.}

\item{absolute}{Default \code{TRUE}. Whether to take the absolute value of the convolution.}

\item{min_value}{Default \code{NULL}. If numeric, specifies he minimum value (for any color channel)
for a pixel to have the convolution performed.}

\item{filename}{Default \code{NULL}. The filename of the image to be saved. If this is not given, the image will be plotted instead.}

\item{preview}{Default \code{TRUE}. Whether to plot the convolved image, or just to return the values.}

\item{gamma_correction}{Default \code{TRUE}. Controls gamma correction when adding colors. Default exponent of 2.2.}

\item{progress}{Default \code{TRUE}. Whether to display a progress bar.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an image and applys a convolution operation to it, using
a user-supplied or built-in kernel. Edges are calculated by limiting the size
of the kernel to only that overlapping the actual image (renormalizing the
kernel for the edges).
}
\examples{
if(rayimage:::run_documentation()){
#Perform a convolution with the default gaussian kernel
plot_image(dragon)
}
if(rayimage:::run_documentation()){
#Perform a convolution with the default gaussian kernel
render_convolution(dragon, preview = TRUE)
}
if(rayimage:::run_documentation()){
#Increase the width of the kernel
render_convolution(dragon, kernel = 2, kernel_dim=21,kernel_extent=6, preview = TRUE)
}
if(rayimage:::run_documentation()){
#Perform edge detection using a edge detection kernel
edge = matrix(c(-1,-1,-1,-1,8,-1,-1,-1,-1),3,3)
render_convolution(dragon, kernel = edge, preview = TRUE, absolute=FALSE)
}
if(rayimage:::run_documentation()){
#Perform edge detection with Sobel matrices
sobel1 = matrix(c(1,2,1,0,0,0,-1,-2,-1),3,3)
sobel2 = matrix(c(1,2,1,0,0,0,-1,-2,-1),3,3,byrow=TRUE)
sob1 = render_convolution(dragon, kernel = sobel1)
sob2 = render_convolution(dragon, kernel = sobel2)
sob_all = sob1 + sob2
plot_image(sob_all)
}
if(rayimage:::run_documentation()){
#Only perform the convolution on bright pixels (bloom)
render_convolution(dragon, kernel = 5, kernel_dim=24, kernel_extent=24,
                  min_value=1, preview = TRUE)
}
if(rayimage:::run_documentation()){
#Use a built-in kernel:
render_convolution(dragon, kernel = generate_2d_exponential(falloff=2, dim=31, width=21),
                  preview = TRUE)
}
if(rayimage:::run_documentation()){
#We can also apply this function to matrices:
volcano |> image()
volcano |>
 render_convolution(kernel=generate_2d_gaussian(sd=1,dim=31)) |>
 image()
}
if(rayimage:::run_documentation()){
#Use a custom kernel (in this case, an X shape):
custom = diag(10) + (diag(10)[,10:1])
plot_image(custom)
render_convolution(dragon, kernel = custom, preview = TRUE)
}
}
