% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray_read_image.R
\name{ray_read_image}
\alias{ray_read_image}
\title{Read Image}
\usage{
ray_read_image(image, convert_to_array = TRUE, preview = FALSE, ...)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{convert_to_array}{Default \code{TRUE}. Whether to convert 2D B&W images/matrices to RGBA arrays.}

\item{preview}{Default \code{FALSE}. If \code{TRUE}, it will display the image in addition
to returning it.}

\item{...}{Arguments to pass to either \code{jpeg::readJPEG}, \code{png::readPNG}, or \code{tiff::readTIFF}.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and adds an image overlay.
}
\examples{
if(run_documentation()){
#Write as a png
tmparr = tempfile(fileext=".png")
ray_read_image(dragon) |>
 ray_write_image(tmparr)
ray_read_image(tmparr) |>
 plot_image()
}
if(run_documentation()){
#Write as a JPEG (passing quality arguments via ...)
tmparr = tempfile(fileext=".jpg")
ray_read_image(dragon) |>
 ray_write_image(tmparr, quality = 0.2)
ray_read_image(tmparr) |>
 plot_image()
}
if(run_documentation()){
#Write as a tiff
tmparr = tempfile(fileext=".tiff")
ray_read_image(dragon) |>
 ray_write_image(tmparr)
ray_read_image(tmparr) |>
  plot_image()
}
}
