% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_vignette.R
\name{add_vignette}
\alias{add_vignette}
\title{Add Vignette Effect}
\usage{
add_vignette(image, vignette = 0.5, filename = NULL, preview = FALSE)
}
\arguments{
\item{image}{Image filename or 3-layer RGB array.}

\item{vignette}{Default \code{0.5}. A camera vignetting effect will be added to the image.
\code{1} is the darkest vignetting, while \code{0} is no vignetting. If vignette is a length-2 vector, the second entry will
control the blurriness of the vignette effect (\code{1} is the default, e.g. \code{2} would double the blurriness but would take
much longer to compute).}

\item{filename}{Default \code{NULL}. Filename which to save the image. If \code{NULL} and \code{preview = FALSE},
returns an RGB array.}

\item{preview}{Default \code{FALSE}. If \code{TRUE}, it will display the image in addition
to returning it.}
}
\value{
3-layer RGB array of the processed image.
}
\description{
Takes an RGB array/filename and adds a camera vignette effect.
}
\examples{
if(interactive()){
#Plot the dragon
plot_image(dragon)

#Add a vignette effect:
\donttest{
add_vignette(dragon, preview = TRUE, vignette = 0.5)
}
#Darken the vignette effect:
\donttest{
add_vignette(dragon, preview = TRUE, vignette = 1)
}

#Increase the width of the blur by 50\%:
\donttest{
add_vignette(dragon, preview = TRUE, vignette = c(1,1.5))
}
}
}
