% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ypos.R
\name{ypos}
\alias{ypos}
\title{Interpolation selecting the nearest neighbor}
\usage{
ypos(y, lat, yk, mercator = FALSE)
}
\arguments{
\item{y}{numeric value of one latitude}

\item{lat}{numeric vector of latitudes from minor to major}

\item{yk}{numeric vector to be approximated}

\item{mercator}{Logical. Is it require to transform the final data
in mercator coordinates? Default is FALSE.}
}
\value{
The position where the latitude y has the minor
difference with lat
}
\description{
This function get the position in a vector of a given latitute y.
}
\examples{
{
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.nc",
                      package = "raytracing")
b <- betaks(u = input)
ykk <- rev(colMeans(b$betam))
ypos(y = -30, lat = seq(90, -90, -2.5), yk = ykk)

}
}
\seealso{
Other Interpolation: 
\code{\link{trin}()}
}
\concept{Interpolation}
