% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-company.R
\name{company_subscriptions_get}
\alias{company_subscriptions_get}
\title{Gets company's subscription rights}
\usage{
company_subscriptions_get(code, cache_folder = cachedir(), do_cache = TRUE)
}
\arguments{
\item{code}{Represents the company, can be the stock symbol, like \code{PETR4} or
the first four characters \code{PETR}}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}
}
\value{
data.frame with company information
}
\description{
Gets a list of all company's subscription rights.
\emph{A subscription right is the right of existing shareholders in a company to
retain an equal percentage ownership by subscribing to new stock issuances
at or below market prices.} (https://www.investopedia.com/)
}
\details{
The \code{code} parameter can be the stock symbol, but the returned data refers
to the company, always.
The returned data.frame has all company's symbols that have issued
subscription rights.
}
\examples{
\dontrun{
company_subscriptions_get(c("PDGR", "VALE", "MGLU"))
}

}
