% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{flux.age.ghost}
\alias{flux.age.ghost}
\title{Plot flux rates for proxies.}
\usage{
flux.age.ghost(
  proxy = 1,
  age.lim = c(),
  yr.lim = age.lim,
  age.res = 200,
  yr.res = age.res,
  set = get("info"),
  flux = c(),
  plot.range = TRUE,
  prob = 0.8,
  range.col = grey(0.5),
  range.lty = 2,
  plot.mean = TRUE,
  mean.col = "red",
  mean.lty = 2,
  flux.lim = c(),
  flux.lab = "flux",
  upper = 0.95,
  rgb.scale = c(0, 0, 0),
  rgb.res = 100,
  dark = set$dark,
  BCAD = set$BCAD,
  age.lab = c(),
  yr.lab = age.lab,
  rotate.axes = FALSE,
  rev.flux = FALSE,
  rev.age = FALSE,
  rev.yr = rev.age
)
}
\arguments{
\item{proxy}{Which proxy to use (counting from the column number in the .csv file after the depths column).}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{age.lim=c()}).}

\item{yr.lim}{Deprecated - use age.lim instead}

\item{age.res}{Resolution or amount of greyscale pixels to cover the age scale of the plot. Default \code{age.res=200}.}

\item{yr.res}{Deprecated - use age.res instead}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{flux}{Define a flux variable within the R session (consisting of depths and their proxy concentrations in two columns) and provide the name of this variable, e.g.:
\code{flux.age.ghost(flux=flux1)}. If left empty (\code{flux=c()}), a flux file is expected (see \code{proxy}).}

\item{plot.range}{Plot curves that indicate a probability range, at resolution of yr.res.}

\item{prob}{Probability range, defaults to \code{prob=0.8} (10 \% at each side).}

\item{range.col}{Red seems nice.}

\item{range.lty}{Line type of the confidence ranges.}

\item{plot.mean}{Plot the mean fluxes.}

\item{mean.col}{Red seems nice.}

\item{mean.lty}{Line type of the means.}

\item{flux.lim}{Limits of the flux axes.}

\item{flux.lab}{Axis labels. Defaults to \code{flux.lab="flux"}.}

\item{upper}{Maximum flux rates to plot. Defaults to the upper 99\%; \code{upper=0.99}.}

\item{rgb.scale}{The function to produce a coloured representation of all age-models. Needs 3 values for the intensity of red, green and blue. Defaults to grey-scales: \code{rgb.scale=c(0,0,0)}, but could also be, say, scales of red (\code{rgb.scale=c(1,0,0)}).}

\item{rgb.res}{Resolution of the colour spectrum depicting the age-depth model. Default \code{rgb.res=100}.}

\item{dark}{The darkest grey value is \code{dark=1} by default; lower values will result in lighter grey but \code{values >1} are not allowed.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{age.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lab}{Deprecated - use age.lab instead}

\item{rotate.axes}{The default of plotting calendar year on the horizontal axis and fluxes on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.flux}{The flux axis can be reversed with \code{rev.flux=TRUE}.}

\item{rev.age}{The direction of the age axis can be reversed using \code{rev.age=TRUE}.}

\item{rev.yr}{Deprecated - use rev.age instead}
}
\value{
A plot of flux rates.
}
\description{
Plot grey-scale representation of estimated flux rates for proxies against calendar age.
}
\details{
To plot flux rates (e.g. pollen grains/cm2/yr) as greyscales,
provide a plain text file with headers and the data in columns separated by commas, ending in '_flux.csv'
and saved in your core's folder. The first column should contain the depths, and the next columns should contain
the proxy concentration values (leaving missing values empty). Then type for example \code{flux.age.ghost(1)} to plot the
flux values for the first proxy in the .csv file. Instead of using a _flux.csv file, a flux variable can also be defined
 within the R session (consisting of depths and their proxy concentrations in two columns). Then provide the name of this variable, e.g.: \code{flux.age.ghost(flux=flux1)}.
See Bacon_runs/MSB2K/MSB2K_flux.csv for an example.
}
\examples{
\dontrun{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth(yr.res=50)
  flux.age.ghost(1)
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
