% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgs.R
\name{sgs_untidy}
\alias{sgs_untidy}
\title{Convert tidy dataframe into a list}
\usage{
sgs_untidy(x, tidydf, as = c("tibble", "xts", "ts"))
}
\arguments{
\item{x}{sgs object with the corresponding codes}

\item{tidydf}{tidy dataframe returned by `rbcb_get`}

\item{as}{the returning type (`tibble`, `xts`, `ts`)}
}
\value{
a list with time series objects
}
\description{
Convert a tidy dataframe into a list of separate time series objects like
`xts` and `ts` or even a `tibble` with a time series representation (
two columns with dates and values).
}
\examples{
\dontrun{
x <- sgs(USD = 1, SELIC = 1178)
df <- rbcb_get(x, from = Sys.Date() - 10)
sgs_untidy(x, df, as = "xts")
}
}
