% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_namecount.R
\name{bhl_namecount}
\alias{bhl_namecount}
\title{Return the number of unique names found on pages in BHL.}
\usage{
bhl_namecount(startdate = NULL, enddate = NULL, as = "table",
  key = NULL, ...)
}
\arguments{
\item{startdate}{start date of range between which to count names (optional)}

\item{enddate}{end date of range between which to count names (optional)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Names both with and without NameBank identifiers are counted.
}
\details{
BEWARE: this API call can take a long time. They are likely working on speeding up the
service, but slow for now.
}
\examples{
\dontrun{
bhl_namecount(startdate = '12/25/2009', enddate = '12/27/2009')
bhl_namecount(startdate = '10/15/2009', enddate = '10/17/2009', as='json')
bhl_namecount(startdate = '10/15/2009', enddate = '10/17/2009', as='xml')
}
}

