% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_publicationsearch.R
\name{bhl_publicationsearch}
\alias{bhl_publicationsearch}
\title{Publication search}
\usage{
bhl_publicationsearch(
  q = NULL,
  full_text = FALSE,
  page = NULL,
  as = "table",
  key = NULL,
  ...
)
}
\arguments{
\item{q}{(character) the text for which to search}

\item{full_text}{(character) \code{TRUE} for a catalog plus full-text search;
\code{FALSE} for a catalog-only search. default: \code{FALSE}}

\item{page}{(integer) page to return}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Publication search
}
\examples{
\dontrun{
bhl_publicationsearch('cocos island costa rica birds')
bhl_publicationsearch('poa annua')
bhl_publicationsearch('helianthus annuus')
}
}
\seealso{
Other publication-search: 
\code{\link{bhl_publicationsearchadv}()}
}
\concept{publication-search}
