% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_enrichment_ppi}
\alias{rba_string_enrichment_ppi}
\title{Get Protein-Protein Interaction Enrichment}
\usage{
rba_string_enrichment_ppi(
  ids,
  species = NULL,
  required_score = NULL,
  background = NULL,
  ...
)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{required_score}{Numeric: A minimum of interaction score for an
interaction to be included in the image. if not supplied, the threshold
will be applied by STRING Based in the network. (low Confidence = 150,
Medium Confidence = 400, High Confidence = 700, Highest confidence = 900)}

\item{background}{character vector: A set of STRING protein IDs
to be used as the background proteome. Only STRING IDs are acceptable.
(See \code{\link{rba_string_map_ids}} to map your IDs.)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list with protein-protein interaction enrichment results.
}
\description{
Even when there is no annotation for your input proteins, STRING can Compare
  your Given proteins interactions pattern with the background proteome-wide
  interaction distribution to determine if your given set of proteins are
  functionally related.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output_format]/ppi_enrichment?identifiers=
 [your_identifiers]&[optional_parameters]"
}

\examples{
\donttest{
rba_string_enrichment_ppi(ids = c("p53", "BRCA1", "cdk2", "Q99835",
       "CDC42", "CDK1", "KIF23", "PLK1", "RAC2", "RACGAP1"),
    species = 9606)
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Annika L Gable, Katerina C Nastou, David Lyon,
  Rebecca Kirsch, Sampo Pyysalo, Nadezhda T Doncheva, Marc Legeay, Tao Fang,
  Peer Bork, Lars J Jensen, Christian von Mering, The STRING database in
  2021: customizable protein–protein networks, and functional
  characterization of user-uploaded gene/measurement sets, Nucleic Acids
  Research, Volume 49, Issue D1, 8 January 2021, Pages D605–D612,
  https://doi.org/10.1093/nar/gkaa1074
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
\code{\link{rba_string_map_ids}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
