% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_sites}
\alias{rba_jaspar_sites}
\title{Get binding sites of a matrix profile}
\usage{
rba_jaspar_sites(matrix_id, ...)
}
\arguments{
\item{matrix_id}{Character: A matrix profile
Identifier. It has "base_id.version" naming schema.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains a data frame with binding sites information.
}
\description{
Use this function to retrieve a list of transcription factor binding sites
  associated with a matrix profile.
}
\section{Corresponding API Resources}{

 "GET "https://jaspar.genereg.net/api/v1/sites/{matrix_id}/"
}

\examples{
\donttest{
rba_jaspar_sites("MA0600.1")
}

}
\references{
\itemize{
  \item Jaime A Castro-Mondragon, Rafael Riudavets-Puig, Ieva
  Rauluseviciute, Roza Berhanu Lemma, Laura Turchi, Romain Blanc-Mathieu,
  Jeremy Lucas, Paul Boddie, Aziz Khan, Nicolás Manosalva Pérez, Oriol
  Fornes, Tiffany Y Leung, Alejandro Aguirre, Fayrouz Hammal, Daniel
  Schmelter, Damir Baranasic, Benoit Ballester, Albin Sandelin, Boris
  Lenhard, Klaas Vandepoele, Wyeth W Wasserman, François Parcy,
  Anthony Mathelier, JASPAR 2022: the 9th release of the open-access
  database of transcription factor binding profiles, Nucleic Acids
  Research, Volume 50, Issue D1, 7 January 2022, Pages D165–D173,
  https://doi.org/10.1093/nar/gkab1113
  \item
  \href{https://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.genereg.net/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_matrix}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
