% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_analysis.R
\name{rba_reactome_analysis_download}
\alias{rba_reactome_analysis_download}
\title{Download Different Reactome Analysis Results}
\usage{
rba_reactome_analysis_download(
  token,
  request,
  save_to = NULL,
  resource = "TOTAL",
  ...
)
}
\arguments{
\item{token}{A token associated to your previous Reactome analysis.}

\item{request}{What to download? Should be one of:\itemize{
\item "found_ids": Download a CSV file containing the found user-supplied
identifiers in the analysis associated with your supplied token and
resource.
\item "not_found_ids"" Download a CSV file containing the user-supplied
Identifiers which has not been found in the analysis associated with your
supplied token.
\item "pathways": Download a CSV file containing Pathway analysis results
of the analysis associated with your supplied token and resource.
\item "results": Download a JSON file containing the complete analysis
results associated with your supplied token.
\item "results_gz" Same as "results", but the output will be compress
(gzipped).}}

\item{save_to}{NULL or Character:\itemize{
\item NULL: Save the file to an automatically-generated path.
\item Character string: A valid file path to save the file to.}}

\item{resource}{(Only when request is "found_ids" or "pathways")
Filter results based on the resource. Default is "TOTAL",
available choices are:"TOTAL", "UNIPROT", "ENSEMBL", "CHEBI", "IUPHAR",
"MIRBASE", "NCBI_PROTEIN", "EMBL", "COMPOUND", "ENTITIES_FDR" or
"PUBCHEM_COMPOUND".}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
NULL, a CSV,JSON or Gzipped JSON file will be saved to disk
  based on your input.
}
\description{
Based on the "request" argument, you can download different analysis
  results data associated with a given token.
}
\details{
Token is associated to each Reactome analysis results and kept by Reactome
  for at least 7 days. You can locate it in
  \code{\link{rba_reactome_analysis}}'s output, under a sub-list named
  "summary" (i.e. results$summary$token).
  \cr Use \code{\link{rba_reactome_analysis_pdf}} to save a full report
  in PDF format.
}
\section{Corresponding API Resources}{

GET https://reactome.org/AnalysisService/download/{token}/entities/
found/{resource}/{filename}.csv"
GET https://reactome.org/AnalysisService//download/{token}/entities/
notfound/{filename}.csv"
GET https://reactome.org/AnalysisService/download/{token}/pathways/
{resource}/{filename}.csv"
GET https://reactome.org/AnalysisService/download/{token}/result.json"
GET https://reactome.org/AnalysisService/download/{token}/result.json.gz"
}

\examples{
\dontrun{
rba_reactome_analysis_download(token = "MjAyMDEwMTYwMTI3MTNfMjY1MjM",
    request = "found_ids", save_to = "found_ids.csv")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/AnalysisService/}{Reactome Analysis
  Services API Documentation}
  \item \href{https://reactome.org/cite}{Citations note on Reactome website}
  }
}
\seealso{
\code{\link{rba_reactome_analysis_pdf}}
\code{\link{rba_reactome_analysis}}

Other "Reactome Analysis Service": 
\code{\link{rba_reactome_analysis_import}()},
\code{\link{rba_reactome_analysis_mapping}()},
\code{\link{rba_reactome_analysis_pdf}()},
\code{\link{rba_reactome_analysis_species}()},
\code{\link{rba_reactome_analysis_token}()},
\code{\link{rba_reactome_analysis}()}
}
\concept{"Reactome Analysis Service"}
