% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_xref}
\alias{rba_reactome_xref}
\title{Map Cross References IDs to Reactome ReferenceEntity}
\usage{
rba_reactome_xref(xref_id, ...)
}
\arguments{
\item{xref_id}{molecule's cross-reference (external) identifier.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing the ReferenceEntity corresponding to your
  supplied cross-reference (external) ID.
}
\description{
Use this function To retrieve a list of Reactome ReferenceEntity associated
  to your supplied Cross Reference (i.e. External) ID.
}
\details{
Reactome cross-references external database's identifiers to it's database
  Entries named ReferenceEntity, which resembles the invariant aspect of
  a molecule. Thus there is a one-to-many relationship between Reactome's
  ReferenceEntity object and the molecule's ID in external databases,
  which in Reactome's terms is called Cross Reference.
  \cr See \code{\link{rba_reactome_participants}}'s "Details section"
  to learn more about how Reactome classifies molecules.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/references/mapping/{identifier}"
}

\examples{
\donttest{
rba_reactome_xref("CD40")
}
\donttest{
rba_reactome_xref("ENSP00000361350")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\concept{"Reactome Content Service - ReferenceEntity Queries"}
