% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_interactions_network}
\alias{rba_string_interactions_network}
\title{Get STRING Network Interactions}
\usage{
rba_string_interactions_network(
  ids,
  species = NULL,
  required_score = NULL,
  add_nodes = NULL,
  network_type = "functional",
  ...
)
}
\arguments{
\item{ids}{Your protein IDs. It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{required_score}{Numeric: A minimum of interaction score for an
interaction to be included in the image. if not supplied, the threshold
will be applied by STRING Based in the network. (low Confidence = 150,
Medium Confidence = 400, High Confidence = 700, Highest confidence = 900)}

\item{add_nodes}{Numeric: Number of neighboring proteins to be added to the
network. If none supplied by the user, this argument value will depend
on the number of supplied "ids" argument:\enumerate{
\item Single id: add_node will be set to 10 to retrieve the interaction
neighborhood  of you input protein.
\item Multiple ids: add_node will be set to 0, thus the output will be the
interactions between your input proteins.}}

\item{network_type}{should be one of:\itemize{
\item "functional": (default) The edge's indicate both physical and
functional associations.
\item "physical": The edges indicate that two proteins have a physical
interaction or are parts of a complex.}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame which each row is a network interaction and the
  columns contains interactor information and interaction scores: \itemize{
  \item stringId_A: STRING identifier (protein A)
  \item stringId_B:STRING identifier (protein B)
  \item preferredName_A: common protein name (protein A)
  \item preferredName_B: common protein name (protein B)
  \item ncbiTaxonId: NCBI taxon identifier
  \item score: combined score
  \item nscore: gene neighborhood score
  \item fscore: gene fusion score
  \item pscore: phylogenetic profile score
  \item ascore: co-expression score
  \item escore: experimental score
  \item dscore: database score
  \item tscore: textmining score}
}
\description{
This function will retrieve Sting interaction pairs among your input protein
  ids, with the combined score and separate score for each STRING score
  channels. You can further expand your network to a defined size by
  providing "add_node" parameter.
}
\details{
Note that this function will return interactions between your set of
  supplied proteins, or at most, expand the interaction network by the
  given parameters. TO retrieve a list of all possible interacting proteins
  with your given input, see
  \code{\link{rba_string_interaction_partners}}.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output-format]/network?identifiers=
 [your_identifiers]&[optional_parameters]"
}

\examples{
\donttest{
rba_string_interactions_network(ids = c("9606.ENSP00000269305",
    "9606.ENSP00000398698",
    "9606.ENSP00000275493"),
    network_type = "functional")
}
\donttest{
rba_string_interactions_network(ids = c("9606.ENSP00000269305",
    "9606.ENSP00000398698",
    "9606.ENSP00000275493"),
    species = 9606,
    add_nodes = 10)
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Annika L Gable, Katerina C Nastou, David Lyon,
  Rebecca Kirsch, Sampo Pyysalo, Nadezhda T Doncheva, Marc Legeay, Tao Fang,
  Peer Bork, Lars J Jensen, Christian von Mering, The STRING database in
  2021: customizable protein–protein networks, and functional
  characterization of user-uploaded gene/measurement sets, Nucleic Acids
  Research, Volume 49, Issue D1, 8 January 2021, Pages D605–D612,
  https://doi.org/10.1093/nar/gkaa1074
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
\code{\link{rba_string_map_ids}, \link{rba_string_interaction_partners}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
