% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_participant_of}
\alias{rba_reactome_participant_of}
\title{Get Larger Reactome Structures Which Include an Entity}
\usage{
rba_reactome_participant_of(entity_id, ...)
}
\arguments{
\item{entity_id}{Reactome's entity ID.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List of Reactome database Entities which Your supplied ID is a
  participant in them.
}
\description{
This function will retrieve a list of complexes and sets that Your
  supplied entity ID participates in (e.g. as a complex component,
  reaction output).
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/entity/\{id\}/componentOf"
}

\examples{
\donttest{
rba_reactome_participant_of(entity_id = "R-HSA-199420")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\seealso{
\code{\link{rba_reactome_participants}}

Other "Reactome Content Service - Physical Entity Queries": 
\code{\link{rba_reactome_complex_list}()},
\code{\link{rba_reactome_complex_subunits}()},
\code{\link{rba_reactome_entity_other_forms}()}
}
\concept{"Reactome Content Service - Physical Entity Queries"}
