% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_epitope_search}
\alias{rba_uniprot_epitope_search}
\title{Search UniProt Epitopes}
\usage{
rba_uniprot_epitope_search(
  accession = NULL,
  epitope_sequence = NULL,
  iedb_id = NULL,
  match_score = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}(s). You can supply up to 100
accession numbers.}

\item{epitope_sequence}{(Character) Epitope's proteins sequence}

\item{iedb_id}{(Numeric) \href{https://www.iedb.org/}{EIDB} epitope
Identifier(s). You can supply up to 20 accession numbers.}

\item{match_score}{Integer: Minimum alignment score for the antigen sequence
and the target protein sequence.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A List where each element corresponds to one UniProt entity returned
  by your search query. The element itself is a sub-list containing all
  information that UniProt has about that entity.
}
\description{
Use this function to search epitope data associated to UniProt entities,
  using various criteria such as UniProt accession, epitope sequence,
  IEDB ID, and match score.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/epitope"
}

\examples{
\donttest{
  rba_uniprot_epitope_search(accession = c("Q84ZX5", "P36222"))
}
\donttest{
  rba_uniprot_epitope_search(epitope_sequence = "DKKCIEWEKAQHGA")
}
\donttest{
  rba_uniprot_epitope_search(iedb_id = 20354)
}

}
\seealso{
Other "UniProt - Epitopes": 
\code{\link{rba_uniprot_epitope}()},
\code{\link{rba_uniprot_rna_edit}()}
}
\concept{"UniProt - Epitopes"}
