% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{method}
\alias{method}
\alias{method_bayes}
\alias{method_approxbayes}
\alias{method_condmean}
\alias{method_bmlmi}
\title{Set the multiple imputation methodology}
\usage{
method_bayes(
  burn_in = 200,
  burn_between = 50,
  same_cov = TRUE,
  n_samples = 20,
  seed = sample.int(.Machine$integer.max, 1)
)

method_approxbayes(
  covariance = c("us", "toep", "cs", "ar1"),
  threshold = 0.01,
  same_cov = TRUE,
  REML = TRUE,
  n_samples = 20
)

method_condmean(
  covariance = c("us", "toep", "cs", "ar1"),
  threshold = 0.01,
  same_cov = TRUE,
  REML = TRUE,
  n_samples = NULL,
  type = c("bootstrap", "jackknife")
)

method_bmlmi(
  covariance = c("us", "toep", "cs", "ar1"),
  threshold = 0.01,
  same_cov = TRUE,
  REML = TRUE,
  B = 20,
  D = 2
)
}
\arguments{
\item{burn_in}{a numeric that specifies how many observations should be discarded
prior to extracting actual samples. Note that the sampler
is initialized at the maximum likelihood estimates and a weakly informative
prior is used thus in theory this value should not need to be that high.}

\item{burn_between}{a numeric that specifies the "thinning" rate i.e. how many
observations should be discarded between each sample. This is used to prevent
issues associated with autocorrelation between the samples.}

\item{same_cov}{a logical, if \code{TRUE} the imputation model will be fitted using a single
shared covariance matrix for all observations. If \code{FALSE} a separate covariance
matrix will be fit for each group as determined by the \code{group} argument of
\code{set_vars()}.}

\item{n_samples}{a numeric that determines how many imputed datasets are generated.
In the case of \code{method_condmean(type = "jackknife")} this argument
must be set to \code{NULL}. See details.}

\item{seed}{a numeric that specifies the seed to be used in the call to Stan. This
argument is passed onto the \code{seed} argument of \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}. Note that
this is only required for \code{method_bayes()}, for all other methods you can achieve
reproducible results by setting the seed via \code{set.seed()}. See details.}

\item{covariance}{a character string that specifies the structure of the covariance
matrix to be used in the imputation model. Must be one of \code{"us"} (default), \code{"toep"},
\code{"cs"} or \code{"ar1"}. See details.}

\item{threshold}{a numeric between 0 and 1, specifies the proportion of bootstrap
datasets that can fail to produce valid samples before an error is thrown.
See details.}

\item{REML}{a logical indicating whether to use REML estimation rather than maximum
likelihood.}

\item{type}{a character string that specifies the resampling method used to perform inference
when a conditional mean imputation approach (set via \code{method_condmean()}) is used. Must be one of \code{"bootstrap"} or \code{"jackknife"}.}

\item{B}{a numeric that determines the number of bootstrap samples for \code{method_bmlmi}.}

\item{D}{a numeric that determines the number of random imputations for each bootstrap sample.
Needed for \code{method_bmlmi()}.}
}
\description{
These functions determine what methods \code{rbmi} should use when creating
the imputation models, generating imputed values and pooling the results.
}
\details{
In the case of \code{method_condmean(type = "bootstrap")} there will be \code{n_samples + 1}
imputation models and datasets generated as the first sample will be based on
the original dataset whilst the other \code{n_samples} samples will be
bootstrapped datasets. Likewise, for \code{method_condmean(type = "jackknife")} there will
be \code{length(unique(data$subjid)) + 1} imputation models and datasets generated. In both cases this is
represented by \code{n + 1} being displayed in the print message.

The user is able to specify different covariance structures using the the \code{covariance}
argument. Currently supported structures include:
\itemize{
\item Unstructured (\code{"us"})
\item Toeplitz (\code{"toep"})
\item Compound Symmetry (\code{"cs"})
\item Autoregression-1 (\code{"ar1"})
}

Note that at present Bayesian methods only support unstructured.

In the case of \code{method_condmean(type = "bootstrap")}, \code{method_approxbayes()} and \code{method_bmlmi()} repeated
bootstrap samples of the original dataset are taken with an MMRM fitted to each sample.
Due to the randomness of these sampled datasets, as well as limitations in the optimisers
used to fit the models, it is not uncommon that estimates for a particular dataset can't
be generated. In these instances \code{rbmi} is designed to throw out that bootstrapped dataset
and try again with another. However to ensure that these errors are due to chance and
not due to some underlying misspecification in the data and/or model a tolerance limit
is set on how many samples can be discarded. Once the tolerance limit has been reached
an error will be thrown and the process aborted. The tolerance limit is defined as
\code{ceiling(threshold * n_samples)}. Note that for the jackknife method estimates need to be
generated for all leave-one-out datasets and as such an error will be thrown if
any of them fail to fit.

Please note that at the time of writing (September 2021) Stan is unable to produce
reproducible samples across different operating systems even when the same seed is used.
As such care must be taken when using Stan across different machines. For more information
on this limitation please consult the Stan documentation
\url{https://mc-stan.org/docs/2_27/reference-manual/reproducibility-chapter.html}
}
