% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancova.R
\name{ancova_single}
\alias{ancova_single}
\title{Implements an Analysis of Covariance (ANCOVA)}
\usage{
ancova_single(
  data,
  outcome,
  group,
  covariates,
  weights = c("counterfactual", "equal", "proportional_em", "proportional")
)
}
\arguments{
\item{data}{A \code{data.frame} containing the data to be used in the model.}

\item{outcome}{Character, the name of the outcome variable in \code{data}.}

\item{group}{Character, the name of the group variable in \code{data}.}

\item{covariates}{Character vector containing the name of any additional covariates
to be included in the model as well as any interaction terms.}

\item{weights}{Character, either \code{"counterfactual"} (default), \code{"equal"},
\code{"proportional_em"} or \code{"proportional"}.
Specifies the weighting strategy to be used when calculating the lsmeans.
See the weighting section for more details.}
}
\description{
Performance analysis of covariance. See \code{\link[=ancova]{ancova()}} for full details.
}
\details{
\itemize{
\item \code{group} must be a factor variable with only 2 levels.
\item \code{outcome} must be a continuous numeric variable.
}
}
\section{Weighting}{

\subsection{Counterfactual}{

For \code{weights = "counterfactual"} (the default) the lsmeans are obtained by
taking the average of the predicted values for each patient after assigning all patients
to each arm in turn.
This approach is equivalent to standardization or g-computation.
In comparison to \code{emmeans} this approach is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{emmeans::emmeans(model, specs = "<treatment>", counterfactual = "<treatment>")
}\if{html}{\out{</div>}}

Note that to ensure backwards compatibility with previous versions of \code{rbmi}
\code{weights = "proportional"} is an alias for \code{weights = "counterfactual"}.
To get results consistent with \code{emmeans}'s \code{weights = "proportional"}
please use \code{weights = "proportional_em"}.
}

\subsection{Equal}{

For \code{weights = "equal"} the lsmeans are obtained by taking the model fitted
value of a hypothetical patient whose covariates are defined as follows:
\itemize{
\item Continuous covariates are set to \code{mean(X)}
\item Dummy categorical variables are set to \code{1/N} where \code{N} is the number of levels
\item Continuous * continuous interactions are set to \code{mean(X) * mean(Y)}
\item Continuous * categorical interactions are set to \code{mean(X) * 1/N}
\item Dummy categorical * categorical interactions are set to \code{1/N * 1/M}
}

In comparison to \code{emmeans} this approach is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{emmeans::emmeans(model, specs = "<treatment>", weights = "equal")
}\if{html}{\out{</div>}}
}

\subsection{Proportional}{

For \code{weights = "proportional_em"} the lsmeans are obtained as per \code{weights = "equal"}
except instead of weighting each observation equally they are weighted by the proportion
in which the given combination of categorical values occurred in the data.
In comparison to \code{emmeans} this approach is equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{emmeans::emmeans(model, specs = "<treatment>", weights = "proportional")
}\if{html}{\out{</div>}}

Note that this is not to be confused with \code{weights = "proportional"} which is an alias
for \code{weights = "counterfactual"}.
}
}

\examples{
\dontrun{
iris2 <- iris[ iris$Species \%in\% c("versicolor", "virginica"), ]
iris2$Species <- factor(iris2$Species)
ancova_single(iris2, "Sepal.Length", "Species", c("Petal.Length * Petal.Width"))
}
}
\seealso{
\code{\link[=ancova]{ancova()}}
}
