% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_plot.R
\name{theme_plot}
\alias{theme_plot}
\title{Override theme parameters for general plot attributes}
\usage{
theme_plot(fig, pars = NULL, background_fill = "white",
  border_fill = "white", outline_line_alpha = 1,
  outline_line_cap = "butt", outline_line_color = "black",
  outline_line_dash = NULL, outline_line_dash_offset = 0,
  outline_line_join = "miter", outline_line_width = 1,
  title_text_align = "left", title_text_alpha = 1,
  title_text_baseline = "bottom", title_text_color = "#444444",
  title_text_font = "Helvetica", title_text_font_size = "12pt",
  title_text_font_style = "normal", min_border = 50,
  min_border_bottom = 50, min_border_left = 50, min_border_right = 50,
  min_border_top = 50)
}
\arguments{
\item{fig}{figure to modify}

\item{pars}{optionally specify a named list of all parameters - useful when dealing with theme lists}

\item{background_fill}{(color) background color of plot}

\item{border_fill}{(color) fill color of border area of plot}

\item{outline_line_alpha}{(numeric) The line alpha for the plot border outline.}

\item{outline_line_cap}{('butt', 'round', 'square') The line cap for the plot border outline.}

\item{outline_line_color}{(color) The line color for the plot border outline.}

\item{outline_line_dash}{The line dash for the plot border outline.}

\item{outline_line_dash_offset}{(integer) The line dash offset for the plot border outline.}

\item{outline_line_join}{('miter', 'round', 'bevel') The line join for the plot border outline.}

\item{outline_line_width}{(integer) The line width for the plot border outline.}

\item{title_text_align}{('left', 'right', 'center') The text align for the plot title.}

\item{title_text_alpha}{The text alpha for the plot title.}

\item{title_text_baseline}{('top', 'middle', 'bottom', 'alphabetic', 'hanging') The text baseline for the plot title.}

\item{title_text_color}{(color) The text color for the plot title.}

\item{title_text_font}{(string) The text font for the plot title.}

\item{title_text_font_size}{(string - e.g. '12pt') The text font size for the plot title.}

\item{title_text_font_style}{('normal', 'italic', 'bold') The text font style for the plot title.}

\item{min_border}{(integer) A convenience property to set all all the min_X_border properties to the same value. If an individual border property is explicitly set, it will override min_border.}

\item{min_border_bottom}{(integer) Minimum size in pixels of the padding region below the bottom of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}

\item{min_border_left}{(integer) Minimum size in pixels of the padding region to the left of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}

\item{min_border_right}{(integer) Minimum size in pixels of the padding region to the right of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}

\item{min_border_top}{(integer) Minimum size in pixels of the padding region above the top of the central plot region. This is a minimum. The padding region may expand as needed to accommodate titles or axes, etc.}
}
\description{
Override theme parameters for general plot attributes
}
\examples{
\donttest{
# manually specify a ggplot-like grid and background
figure() \%>\%
  ly_points(1:10) \%>\%
  theme_plot(background_fill = "#E6E6E6",
    outline_line_color = "white") \%>\%
  theme_grid(c("x", "y"), grid_line_color = "white",
    minor_grid_line_color = "white",
    minor_grid_line_alpha = 0.4) \%>\%
  theme_axis(c("x", "y"), axis_line_color = "white",
    major_label_text_color = "#7F7F7F",
    major_tick_line_color = "#7F7F7F",
    minor_tick_line_alpha = 0, num_minor_ticks = 2)

# or use the built in ggplot theme (under development)
figure() \%>\%
  ly_points(1:10) \%>\%
  set_theme(bk_ggplot_theme)

# or to set the theme for all future plots
options(bokeh_theme = bk_ggplot_theme)

figure() \%>\%
  ly_points(1:10)

figure() \%>\%
  ly_boxplot(1:10)

}
}

