% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_image.R
\name{ly_image_url}
\alias{ly_image_url}
\title{Add an "image_url" layer to a Bokeh figure}
\usage{
ly_image_url(
  fig,
  x = 0,
  y = 0,
  data = figure_data(fig),
  w = 10,
  h = 10,
  image_url,
  dilate = TRUE,
  anchor = "top_left",
  angle = 0,
  lname = NULL,
  lgroup = NULL
)
}
\arguments{
\item{fig}{figure to modify}

\item{x}{x coordinates}

\item{y}{y coordinates}

\item{data}{an optional data frame, providing the source for inputs x, y, and other properties}

\item{w, h}{values or field names of width and height of image}

\item{image_url}{values or field name of image URLs}

\item{dilate}{logical - whether to dilate pixel distance computations when drawing}

\item{anchor}{where the image is anchored to with respect to \code{x} and \code{y}}

\item{angle}{values or field name of the angle to rotate the image, in radians}

\item{lname}{layer name}

\item{lgroup}{layer group}
}
\description{
Renders raster images from URLs at provided coordinates
}
\examples{
\donttest{
url <- c("  http://bokeh.pydata.org/en/latest/_static/images/logo.png",
  "http://developer.r-project.org/Logo/Rlogo-4.png")

ss <- seq(0, 2*pi, length = 13)[-1]
ws <- runif(12, 2.5, 5) * rep(c(1, 0.8), 6)

imgdat <- data.frame(
  x = sin(ss) * 10, y = cos(ss) * 10,
  w = ws, h = ws * rep(c(1, 0.76), 6),
  url = rep(url, 6)
)

p <- figure(xlab = "x", ylab = "y") \%>\%
  ly_image_url(x, y, w = w, h = h, image_url = url, data = imgdat,
    anchor = "center") \%>\%
  ly_lines(sin(c(ss, ss[1])) * 10, cos(c(ss, ss[1])) * 10,
    width = 15, alpha = 0.1)
p
}
}
\seealso{
Other layer functions: 
\code{\link{ly_abline}()},
\code{\link{ly_annular_wedge}()},
\code{\link{ly_annulus}()},
\code{\link{ly_arc}()},
\code{\link{ly_bar}()},
\code{\link{ly_bezier}()},
\code{\link{ly_boxplot}()},
\code{\link{ly_contour}()},
\code{\link{ly_crect}()},
\code{\link{ly_curve}()},
\code{\link{ly_density}()},
\code{\link{ly_hist}()},
\code{\link{ly_image}()},
\code{\link{ly_lines}()},
\code{\link{ly_map}()},
\code{\link{ly_multi_line}()},
\code{\link{ly_oval}()},
\code{\link{ly_patch}()},
\code{\link{ly_points}()},
\code{\link{ly_polygons}()},
\code{\link{ly_quadratic}()},
\code{\link{ly_quantile}()},
\code{\link{ly_ray}()},
\code{\link{ly_rect}()},
\code{\link{ly_segments}()},
\code{\link{ly_text}()},
\code{\link{ly_wedge}()}
}
\concept{layer functions}
