% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_tool.R
\name{tool_box_zoom}
\alias{tool_box_zoom}
\title{Add "box_zoom" tool to a Bokeh figure}
\usage{
tool_box_zoom(
  fig,
  line_color = "black",
  line_alpha = 1,
  fill_color = "lightgrey",
  fill_alpha = 0.5,
  line_width = 2,
  line_dash = c(4, 4),
  level = "overlay"
)
}
\arguments{
\item{fig}{figure to modify}

\item{line_color, line_alpha, fill_color, fill_alpha, line_width, line_dash, level}{parameters to control the look of the selection bounding region}
}
\description{
Add "box_zoom" tool to a Bokeh figure
}
\note{
Tools can be easily specified as a vector of tool names in the \code{tools} argument when instantiating a \code{\link{figure}}.  In this case, they are added with defaults.  Explicitly calling these \code{tool_} functions will manually add the tool to a figure and allow additional specification of parameters.
}
\examples{
\donttest{
figure() \%>\% ly_points(1:10) \%>\%
 tool_box_zoom()
}
}
\seealso{
Other tools: 
\code{\link{tool_box_select}()},
\code{\link{tool_crosshair}()},
\code{\link{tool_hover}()},
\code{\link{tool_lasso_select}()},
\code{\link{tool_pan}()},
\code{\link{tool_reset}()},
\code{\link{tool_resize}()},
\code{\link{tool_save}()},
\code{\link{tool_tap}()},
\code{\link{tool_wheel_zoom}()}
}
\concept{tools}
