% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.w_naive_bayes.R
\name{predict.w_naive_bayes}
\alias{predict.w_naive_bayes}
\title{Naive Bayes algorithm with case weights}
\usage{
\method{predict}{w_naive_bayes}(object, newdata = NULL, type = "prob", ...)
}
\arguments{
\item{object}{"naive_bayes" class object from naive_bayes function.}

\item{newdata}{new observations which predictions will be made on.}

\item{type}{"pred" or "prob".}
}
\value{
A vector of class predictions or a matrix of class probabilities
depending of \code{type}
}
\description{
Function for Naive Bayes algorithm prediction.
}
\details{
Type "pred" will give class predictions. "prob" will give probabilities for
each class.
}
\examples{
data(iris)

x <- iris[,1:4]
y <- iris[,5]

# Without weights
m <- w_naive_bayes(x_train = x, y_train = y)
preds <- predict(object = m, newdata = x, type = "pred")
table(y, preds)

# Using weights
weights <- ifelse(y == "setosa" | y == "versicolor", 1, 0.01)

m <- w_naive_bayes(x_train = x, y_train = y, w = weights)
preds <- predict(object = m, newdata = x, type = "pred")
table(y, preds)

# Using weights example 2
weights <- ifelse(y == "setosa" | y == "virginica", 1, 0.01)

m <- w_naive_bayes(x_train = x, y_train = y, w = weights)
preds <- predict(object = m, newdata = x, type = "pred")
table(y, preds)

}
\keyword{internal}
