% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{peace}
\alias{peace}
\title{Data on Public Support for War in a Sample of US Respondents}
\format{
A data frame with 1,273 rows and 17 columns: \describe{
  \item{threatc}{number of adverse events respondents considered probable if the US did not engage in war}
  \item{ally}{a dummy variable indicating whether the country had signed a military alliance with the US}
  \item{trade}{a dummy variable indicating whether the country had high levels of trade with the US}
  \item{h1}{an index measuring respondent's attitude toward militarism}
  \item{i1}{an index measuring respondent's attitude toward internationalism}
  \item{p1}{an index measuring respondent's identification with the Republican party}
  \item{e1}{an index measuring respondent's attitude toward ethnocentrism}
  \item{r1}{an index measuring respondent's attitude toward religiosity}
  \item{male}{a dummy variable indicating whether the respondent is male}
  \item{white}{a dummy variable indicating whether the respondent is white}
  \item{age}{respondent's age}
  \item{ed4}{respondent's education with categories ranging from high school or less to postgraduate degree}
  \item{democ}{a dummy variable indicating whether the country was a democracy}
  \item{strike}{a measure of support for war on a five-point scale}
  \item{cost}{number of negative consequences anticipated if the US engaged in war}
  \item{successc}{whether the respondent thought the operation would succeed. 0: less than 50-50 chance of working even in the short run; 1: efficacious only in the short run; 2: successful both in the short and long run}
  \item{immoral}{a dummy variable indicating whether respondents thought it would be morally wrong to strike the country}
  }
}
\usage{
peace
}
\description{
A dataset containing 17 variables on the views of 1,273 US adults about their support
for war against countries that were hypothetically developing nuclear weapons. The data include
several variables on the country's features and respondents' demographic and attitudinal characteristics
(Tomz and Weeks 2013; Zhou and Wodtke 2020).
}
\references{
Tomz, Michael R., and Jessica L. P. Weeks. 2013. Public Opinion and the Democratic Peace.
  The American Political Science Review 107(4):849-65.

Zhou, Xiang, and Geoffrey T. Wodtke. 2020. Residual Balancing:
  A Method of Constructing Weights for Marginal Structural Models. Political Analysis 28(4):487-506.
}
\keyword{datasets}
