% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windExampleData.R
\docType{data}
\name{windExample}
\alias{windExample}
\alias{windPt}
\alias{windPoly}
\alias{windGrid}
\title{Wind Point Observations}
\format{
windExample contains 3 objects
  \describe{
     \item{windPt}{A SpatialPointsDataFrame containing 6916 points. The
       data.frame contains only one column, "vel", the observed wind velocity.}
     \item{windPoly}{A SpatialPolygonsDataFrame containing 4551 areas. The
       data.frame contains only one column, "vel", the observed wind velocity.}
     \item{windGrid}{A SptialPolygons object providing a 0.5 degree grid 
       that covers the measurement area of the Mediterranean Sea.}
  }
}
\usage{
data(windExample)
}
\description{
This data set is a sample of ocean surface wind data with observations from 
 2 February 2005 at 12:00 Universal Coordinated Time over the Mediterranean Sea
 using the QuickSCAT scatterometer. Provided only to facilitate 
 illustrative examples.
}
\references{
Milliff, R., Bonazzi, A., Wikle,C., Pinardi,N. and Berliner, L. 
  (2011). Ocean ensemble forecasting: Part I, Ensemble
  Mediterranean winds from a Bayesian hierarchical model. Quarterly Journal of
  the Royal Meteorological Society, 137, 858--878.

  Wikle, C. K., Milliff, R. F., Herbei, R., and Leeds, W. B., (2013). 
  Modern statistical methods in oceanography: A hierarchical perspective. 
  Statistical Science, 28, 466-486. DOI: 10.1214/13-STS436
}
\keyword{datasets}
